/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.security.tls;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public class TransportSecurityOptions {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Path privateKeyFile;
    private final Path certificatesFile;
    private final Path caCertificatesFile;

    public TransportSecurityOptions(String privateKeyFile, String certificatesFile, String caCertificatesFile) {
        this(Paths.get(privateKeyFile, new String[0]), Paths.get(certificatesFile, new String[0]), Paths.get(caCertificatesFile, new String[0]));
    }

    public TransportSecurityOptions(Path privateKeyFile, Path certificatesFile, Path caCertificatesFile) {
        this.privateKeyFile = privateKeyFile;
        this.certificatesFile = certificatesFile;
        this.caCertificatesFile = caCertificatesFile;
    }

    public Path getPrivateKeyFile() {
        return this.privateKeyFile;
    }

    public Path getCertificatesFile() {
        return this.certificatesFile;
    }

    public Path getCaCertificatesFile() {
        return this.caCertificatesFile;
    }

    public static TransportSecurityOptions fromJsonFile(Path file) {
        try {
            return TransportSecurityOptions.fromJsonNode(mapper.readTree(file.toFile()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static TransportSecurityOptions fromJson(String json) {
        try {
            return TransportSecurityOptions.fromJsonNode(mapper.readTree(json));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static TransportSecurityOptions fromJsonNode(JsonNode root) {
        JsonNode filesNode = TransportSecurityOptions.getField(root, "files");
        String privateKeyFile = TransportSecurityOptions.getField(filesNode, "private-key").asText();
        String certificatesFile = TransportSecurityOptions.getField(filesNode, "certificates").asText();
        String caCertificatesFile = TransportSecurityOptions.getField(filesNode, "ca-certificates").asText();
        return new TransportSecurityOptions(privateKeyFile, certificatesFile, caCertificatesFile);
    }

    private static JsonNode getField(JsonNode root, String fieldName) {
        return Optional.ofNullable(root.get(fieldName)).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' field missing", fieldName)));
    }

    public String toString() {
        return "TransportSecurityOptions{privateKeyFile=" + this.privateKeyFile + ", certificatesFile=" + this.certificatesFile + ", caCertificatesFile=" + this.caCertificatesFile + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportSecurityOptions that = (TransportSecurityOptions)o;
        return Objects.equals(this.privateKeyFile, that.privateKeyFile) && Objects.equals(this.certificatesFile, that.certificatesFile) && Objects.equals(this.caCertificatesFile, that.caCertificatesFile);
    }

    public int hashCode() {
        return Objects.hash(this.privateKeyFile, this.certificatesFile, this.caCertificatesFile);
    }
}

