/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.FilterExpressionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.Objects;
import java.util.Optional;

public class RangePredicateNode
extends FilterExpressionNode {
    public static final int classId = RangePredicateNode.registerClass((int)16562, RangePredicateNode.class, RangePredicateNode::new);
    private Number lower;
    private Number upper;
    private boolean lowerInclusive;
    private boolean upperInclusive;
    private ExpressionNode expression;

    public RangePredicateNode() {
    }

    public RangePredicateNode(Number lower, Number upper, ExpressionNode expression, boolean lowerInclusive, boolean upperInclusive) {
        this.lower = lower;
        this.upper = upper;
        this.lowerInclusive = lowerInclusive;
        this.upperInclusive = upperInclusive;
        this.expression = expression;
    }

    public Number getLower() {
        return this.lower;
    }

    public Number getUpper() {
        return this.upper;
    }

    public boolean getLowerInclusive() {
        return this.lowerInclusive;
    }

    public boolean getUpperInclusive() {
        return this.upperInclusive;
    }

    public Optional<ExpressionNode> getExpression() {
        return Optional.ofNullable(this.expression);
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    public RangePredicateNode clone() {
        return new RangePredicateNode(this.lower, this.upper, this.expression != null ? this.expression.clone() : null, this.lowerInclusive, this.upperInclusive);
    }

    @Override
    protected void onSerialize(Serializer buf) {
        buf.putDouble(null, this.lower.doubleValue());
        buf.putDouble(null, this.upper.doubleValue());
        buf.putByte(null, (byte)(this.lowerInclusive ? 1 : 0));
        buf.putByte(null, (byte)(this.upperInclusive ? 1 : 0));
        RangePredicateNode.serializeOptional((Serializer)buf, (Identifiable)this.expression);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        this.lower = buf.getDouble(null);
        this.upper = buf.getDouble(null);
        this.lowerInclusive = buf.getByte(null) != 0;
        this.upperInclusive = buf.getByte(null) != 0;
        this.expression = (ExpressionNode)RangePredicateNode.deserializeOptional((Deserializer)buf);
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("lower", (Object)this.lower);
        visitor.visit("upper", (Object)this.upper);
        visitor.visit("lowerInclusive", (Object)this.lowerInclusive);
        visitor.visit("upperInclusive", (Object)this.upperInclusive);
        visitor.visit("expression", (Object)this.expression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RangePredicateNode that = (RangePredicateNode)((Object)o);
        return Objects.equals(this.lower, that.lower) && Objects.equals(this.upper, that.upper) && Objects.equals(this.lowerInclusive, that.lowerInclusive) && Objects.equals(this.upperInclusive, that.upperInclusive) && Objects.equals(this.expression, that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.lower, this.upper, this.lowerInclusive, this.upperInclusive, this.expression);
    }
}

