/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.treenet.rule;

import com.yahoo.searchlib.treenet.rule.Condition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SetMembershipCondition
extends Condition {
    private final List<Object> setValues;

    public SetMembershipCondition(String testValue, List<Object> setValues, String trueLabel, String falseLabel) {
        super(testValue, trueLabel, falseLabel);
        this.setValues = Collections.unmodifiableList(new ArrayList<Object>(setValues));
    }

    public List<Object> getSetValues() {
        return this.setValues;
    }

    @Override
    protected String conditionToRankingExpression() {
        StringBuilder b = new StringBuilder("in [");
        Iterator<Object> i = this.setValues.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            if (value instanceof String) {
                b.append("\"").append(value).append("\"");
            } else if (value instanceof Integer) {
                b.append(value);
            } else {
                throw new RuntimeException("Excepted a string or integer in a set membership test, not a " + String.valueOf(value.getClass()) + ": " + String.valueOf(value));
            }
            if (!i.hasNext()) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }
}

