/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.aggregation.RawData;
import com.yahoo.searchlib.expression.PositiveInfinityResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.SingleResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.Arrays;

public class RawResultNode
extends SingleResultNode {
    public static final int classId = RawResultNode.registerClass((int)16438, RawResultNode.class, RawResultNode::new);
    private static final RawResultNode negativeInfinity = new RawResultNode();
    private static final PositiveInfinityResultNode positiveInfinity = new PositiveInfinityResultNode();
    private RawData value = null;

    public RawResultNode() {
        this.value = new RawData();
    }

    public RawResultNode(byte[] value) {
        this.setValue(value);
    }

    public RawResultNode setValue(byte[] value) {
        this.value = new RawData(value);
        return this;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        this.value.serialize(buf);
    }

    protected void onDeserialize(Deserializer buf) {
        this.value = new RawData();
        this.value.deserialize(buf);
    }

    @Override
    public long getInteger() {
        return 0L;
    }

    @Override
    public double getFloat() {
        return 0.0;
    }

    @Override
    public String getString() {
        return new String(this.value.getData());
    }

    @Override
    public byte[] getRaw() {
        return this.value.getData();
    }

    public String toString() {
        if (this.value != null) {
            return Arrays.toString(this.value.getData());
        }
        return "[]";
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        return rhs instanceof PositiveInfinityResultNode ? -1 : RawData.compare(this.value.getData(), rhs.getRaw());
    }

    public int hashCode() {
        return super.hashCode() + this.value.hashCode();
    }

    public RawResultNode clone() {
        RawResultNode obj = (RawResultNode)super.clone();
        if (this.value != null) {
            obj.value = (RawData)this.value.clone();
        }
        return obj;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("value", (Object)this.value);
    }

    @Override
    public void add(ResultNode rhs) {
        byte[] nb = new byte[this.value.getData().length + rhs.getRaw().length];
        System.arraycopy(this.value.getData(), 0, nb, 0, this.value.getData().length);
        System.arraycopy(rhs.getRaw(), 0, nb, this.value.getData().length, rhs.getRaw().length);
        this.value = new RawData(nb);
    }

    @Override
    public void min(ResultNode rhs) {
        RawData b = new RawData(rhs.getRaw());
        if (this.value.compareTo(b) > 0) {
            this.value = b;
        }
    }

    @Override
    public void max(ResultNode rhs) {
        RawData b = new RawData(rhs.getRaw());
        if (this.value.compareTo(b) < 0) {
            this.value = b;
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void set(ResultNode rhs) {
        this.value = new RawData(rhs.getRaw());
    }

    @Override
    public void negate() {
        byte[] data = this.value.getData();
        for (int i = 0; i < data.length; ++i) {
            data[i] = -data[i];
        }
    }

    public static RawResultNode getNegativeInfinity() {
        return negativeInfinity;
    }

    public static PositiveInfinityResultNode getPositiveInfinity() {
        return positiveInfinity;
    }
}

