/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.aggregation.GroupingLevel;
import com.yahoo.searchlib.expression.AggregationRefNode;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class Group
extends Identifiable {
    public static final int classId = Group.registerClass((int)16474, Group.class, Group::new);
    private static final ObjectPredicate REF_LOCATOR = new RefLocator();
    private static final int MAX_AGGREGATIONS = 65536;
    private static final int MAX_ORDERBY_EXPRESSIONS = 8;
    private List<Integer> orderByIdx = List.of();
    private List<ExpressionNode> orderByExp = List.of();
    private List<AggregationResult> aggregationResults = List.of();
    private List<Group> children = List.of();
    private ResultNode id = null;
    private double rank;
    private int tag = -1;
    private SortType sortType = SortType.UNSORTED;

    private static <T> List<T> add(List<T> oldList, T obj) {
        if (oldList.isEmpty()) {
            return List.of(obj);
        }
        if (oldList.size() == 1) {
            return List.of(oldList.get(0), obj);
        }
        ArrayList<T> newList = oldList instanceof ArrayList ? oldList : new ArrayList<T>(oldList);
        newList.add(obj);
        return newList;
    }

    private static <T> List<T> sort(List<T> list, Comparator<T> cmp) {
        if (list instanceof ArrayList) {
            list.sort(cmp);
            return list;
        }
        if (list.size() < 2) {
            return list;
        }
        if (list.size() == 2) {
            return cmp.compare(list.get(0), list.get(1)) > 0 ? List.of(list.get(1), list.get(0)) : list;
        }
        return list.stream().sorted(cmp).toList();
    }

    public boolean isRankedByRelevance() {
        return this.orderByIdx.isEmpty();
    }

    public void merge(int firstLevel, int currentLevel, Group rhs) {
        if (rhs.rank > this.rank) {
            this.rank = rhs.rank;
        }
        if (currentLevel >= firstLevel) {
            int len = this.aggregationResults.size();
            for (int i = 0; i < len; ++i) {
                this.aggregationResults.get(i).merge(rhs.aggregationResults.get(i));
            }
        }
        ArrayList<Group> merged = new ArrayList<Group>();
        Iterator<Group> lhsChild = this.children.iterator();
        Iterator<Group> rhsChild = rhs.children.iterator();
        if (lhsChild.hasNext() && rhsChild.hasNext()) {
            Group lhsGroup = lhsChild.next();
            Group rhsGroup = rhsChild.next();
            while (lhsGroup != null && rhsGroup != null) {
                int cmp = lhsGroup.getId().compareTo(rhsGroup.getId());
                if (cmp < 0) {
                    merged.add(lhsGroup);
                    lhsGroup = lhsChild.hasNext() ? lhsChild.next() : null;
                    continue;
                }
                if (cmp > 0) {
                    merged.add(rhsGroup);
                    rhsGroup = rhsChild.hasNext() ? rhsChild.next() : null;
                    continue;
                }
                lhsGroup.merge(firstLevel, currentLevel + 1, rhsGroup);
                merged.add(lhsGroup);
                lhsGroup = lhsChild.hasNext() ? lhsChild.next() : null;
                rhsGroup = rhsChild.hasNext() ? rhsChild.next() : null;
            }
            if (lhsGroup != null) {
                merged.add(lhsGroup);
            }
            if (rhsGroup != null) {
                merged.add(rhsGroup);
            }
        }
        while (lhsChild.hasNext()) {
            merged.add(lhsChild.next());
        }
        while (rhsChild.hasNext()) {
            merged.add(rhsChild.next());
        }
        this.children = merged;
    }

    private void executeOrderBy() {
        for (ExpressionNode node : this.orderByExp) {
            node.prepare();
            node.execute();
        }
    }

    public void postMerge(List<GroupingLevel> levels, int firstLevel, int currentLevel) {
        if (currentLevel >= firstLevel) {
            for (AggregationResult aggregationResult : this.aggregationResults) {
                aggregationResult.postMerge();
            }
            for (ExpressionNode expressionNode : this.orderByExp) {
                expressionNode.execute();
            }
        }
        if (currentLevel < levels.size()) {
            int maxGroups = (int)levels.get(currentLevel).getMaxGroups();
            for (Group group : this.children) {
                group.executeOrderBy();
            }
            if (maxGroups >= 0 && this.children.size() > maxGroups) {
                this.sortChildrenByRank();
                this.children = this.children.subList(0, maxGroups);
                this.sortChildrenById();
            }
            for (Group group : this.children) {
                group.postMerge(levels, firstLevel, currentLevel + 1);
            }
        }
    }

    public void sortChildrenById() {
        if (this.sortType == SortType.BYID) {
            return;
        }
        this.children = Group.sort(this.children, Group::compareId);
        this.sortType = SortType.BYID;
    }

    public void sortChildrenByRank() {
        if (this.sortType == SortType.BYRANK) {
            return;
        }
        this.children = Group.sort(this.children, Group::compareRank);
        this.sortType = SortType.BYRANK;
    }

    public ResultNode getId() {
        return this.id;
    }

    public Group setId(ResultNode id) {
        this.id = id;
        return this;
    }

    public Group setRank(double rank) {
        this.rank = rank;
        return this;
    }

    public double getRank() {
        return this.rank;
    }

    public Group addChild(Group child) {
        if (child == null) {
            throw new IllegalArgumentException("Child can not be null.");
        }
        this.children = Group.add(this.children, child);
        return this;
    }

    public List<Group> getChildren() {
        return List.copyOf(this.children);
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public int getTag() {
        return this.tag;
    }

    public Group setTag(int tag) {
        this.tag = tag;
        return this;
    }

    public List<AggregationResult> getAggregationResults() {
        return List.copyOf(this.aggregationResults);
    }

    public Group addAggregationResult(AggregationResult result) {
        if (this.aggregationResults.size() >= 65536) {
            throw new IllegalArgumentException("You have reached the limit for number of aggregations of 65536");
        }
        this.aggregationResults = Group.add(this.aggregationResults, result);
        return this;
    }

    public Group addOrderBy(ExpressionNode exp, boolean asc) {
        if (this.orderByExp.size() >= 8) {
            throw new IllegalArgumentException("You have reached the limit for number of orderby expressions of 8");
        }
        if (exp instanceof AggregationResult) {
            exp = new AggregationRefNode((AggregationResult)exp);
        }
        RefResolver refResolver = new RefResolver(this.aggregationResults);
        exp.select(REF_LOCATOR, refResolver);
        this.aggregationResults = refResolver.results;
        this.orderByExp = Group.add(this.orderByExp, exp);
        this.orderByIdx = Group.add(this.orderByIdx, (asc ? 1 : -1) * this.orderByExp.size());
        return this;
    }

    public List<Integer> getOrderByIndexes() {
        return List.copyOf(this.orderByIdx);
    }

    public List<ExpressionNode> getOrderByExpressions() {
        return List.copyOf(this.orderByExp);
    }

    private int compareId(Group rhs) {
        return this.getId().compareTo(rhs.getId());
    }

    private int compareRank(Group rhs) {
        int rawIndex;
        long diff = 0L;
        int m = this.orderByIdx.size();
        for (int i = 0; diff == 0L && i < m; diff *= (long)rawIndex, ++i) {
            rawIndex = this.orderByIdx.get(i);
            int index = (rawIndex < 0 ? -rawIndex : rawIndex) - 1;
            diff = this.orderByExp.get(index).getResult().compareTo(rhs.orderByExp.get(index).getResult());
        }
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return -Double.compare(this.rank, rhs.rank);
    }

    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        Group.serializeOptional((Serializer)buf, (Identifiable)this.id);
        buf.putDouble(null, this.rank);
        int sz = this.orderByIdx.size();
        buf.putInt(null, sz);
        for (Integer n : this.orderByIdx) {
            buf.putInt(null, n.intValue());
        }
        int numResults = this.aggregationResults.size();
        buf.putInt(null, numResults);
        for (AggregationResult aggregationResult : this.aggregationResults) {
            Group.serializeOptional((Serializer)buf, (Identifiable)aggregationResult);
        }
        int n = this.orderByExp.size();
        buf.putInt(null, n);
        for (ExpressionNode e : this.orderByExp) {
            Group.serializeOptional((Serializer)buf, (Identifiable)e);
        }
        int n2 = this.children.size();
        buf.putInt(null, n2);
        for (Group g : this.children) {
            g.serializeWithId(buf);
        }
        buf.putInt(null, this.tag);
    }

    protected void onDeserialize(Deserializer buf) {
        int i;
        int numResults;
        super.onDeserialize(buf);
        this.id = (ResultNode)Group.deserializeOptional((Deserializer)buf);
        this.rank = buf.getDouble(null);
        this.orderByIdx = List.of();
        int orderByCount = buf.getInt(null);
        if (orderByCount > 0) {
            Integer[] idxes = new Integer[orderByCount];
            for (int i2 = 0; i2 < orderByCount; ++i2) {
                idxes[i2] = buf.getInt(null);
            }
            this.orderByIdx = List.of(idxes);
        }
        if ((numResults = buf.getInt(null)) > 0) {
            AggregationResult[] results = new AggregationResult[numResults];
            for (int i3 = 0; i3 < numResults; ++i3) {
                results[i3] = (AggregationResult)Group.deserializeOptional((Deserializer)buf);
            }
            this.aggregationResults = List.of(results);
        } else {
            this.aggregationResults = List.of();
        }
        int numExpressionResults = buf.getInt(null);
        if (numExpressionResults > 0) {
            RefResolver resolver = new RefResolver(this.aggregationResults);
            ExpressionNode[] orderBy = new ExpressionNode[numExpressionResults];
            for (i = 0; i < numExpressionResults; ++i) {
                ExpressionNode exp = (ExpressionNode)Group.deserializeOptional((Deserializer)buf);
                exp.select(REF_LOCATOR, resolver);
                orderBy[i] = exp;
            }
            this.aggregationResults = resolver.results;
            this.orderByExp = List.of(orderBy);
        } else {
            this.orderByExp = List.of();
        }
        int numGroups = buf.getInt(null);
        if (numGroups > 0) {
            Group[] groups = new Group[numGroups];
            for (i = 0; i < numGroups; ++i) {
                Group g = new Group();
                g.deserializeWithId(buf);
                groups[i] = g;
            }
            this.children = List.of(groups);
        } else {
            this.children = List.of();
        }
        this.tag = buf.getInt(null);
    }

    public int hashCode() {
        return super.hashCode() + this.aggregationResults.hashCode() + this.children.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Group rhs = (Group)((Object)obj);
        if (!Group.equals((Object)this.id, (Object)rhs.id)) {
            return false;
        }
        if (this.rank != rhs.rank) {
            return false;
        }
        if (!this.aggregationResults.equals(rhs.aggregationResults)) {
            return false;
        }
        if (!this.orderByIdx.equals(rhs.orderByIdx)) {
            return false;
        }
        if (!this.orderByExp.equals(rhs.orderByExp)) {
            return false;
        }
        return this.children.equals(rhs.children);
    }

    public Group clone() {
        int i;
        Group obj = (Group)super.clone();
        if (this.id != null) {
            obj.id = (ResultNode)this.id.clone();
        }
        if (!this.aggregationResults.isEmpty()) {
            AggregationResult[] results = new AggregationResult[this.aggregationResults.size()];
            i = 0;
            for (AggregationResult aggregationResult : this.aggregationResults) {
                results[i++] = aggregationResult.clone();
            }
            obj.aggregationResults = List.of(results);
        }
        obj.orderByIdx = List.copyOf(this.orderByIdx);
        if (!this.orderByExp.isEmpty()) {
            obj.orderByExp = new ArrayList<ExpressionNode>();
            RefResolver resolver = new RefResolver(obj.aggregationResults);
            ExpressionNode[] orderBy = new ExpressionNode[this.orderByExp.size()];
            int i2 = 0;
            for (ExpressionNode exp : this.orderByExp) {
                exp = exp.clone();
                exp.select(REF_LOCATOR, resolver);
                orderBy[i2++] = exp;
            }
            obj.orderByExp = List.of(orderBy);
            obj.aggregationResults = resolver.results;
        }
        if (!this.children.isEmpty()) {
            Group[] groups = new Group[this.children.size()];
            i = 0;
            for (Group group : this.children) {
                groups[i++] = group.clone();
            }
            obj.children = List.of(groups);
        }
        return obj;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("id", (Object)this.id);
        visitor.visit("rank", (Object)this.rank);
        visitor.visit("aggregationresults", this.aggregationResults);
        visitor.visit("orderby-idx", this.orderByIdx);
        visitor.visit("orderby-exp", this.orderByExp);
        visitor.visit("children", this.children);
        visitor.visit("tag", (Object)this.tag);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        for (AggregationResult result : this.aggregationResults) {
            result.select(predicate, operation);
        }
        for (ExpressionNode exp : this.orderByExp) {
            exp.select(predicate, operation);
        }
    }

    private static enum SortType {
        UNSORTED,
        BYRANK,
        BYID;

    }

    private static class RefResolver
    implements ObjectOperation {
        List<AggregationResult> results;

        RefResolver(List<AggregationResult> initial) {
            this.results = initial;
        }

        public void execute(Object obj) {
            AggregationRefNode ref = (AggregationRefNode)obj;
            int idx = ref.getIndex();
            if (idx < 0) {
                AggregationResult res = ref.getExpression();
                idx = this.indexOf(res);
                if (idx < 0) {
                    idx = this.results.size();
                    this.results = Group.add(this.results, res);
                }
                ref.setIndex(idx);
            } else {
                ref.setExpression(this.results.get(idx));
            }
        }

        int indexOf(AggregationResult lhs) {
            int prevTag = lhs.getTag();
            int len = this.results.size();
            for (int i = 0; i < len; ++i) {
                AggregationResult rhs = this.results.get(i);
                lhs.setTag(rhs.getTag());
                if (!lhs.equals(rhs)) continue;
                return i;
            }
            lhs.setTag(prevTag);
            return -1;
        }
    }

    private static class RefLocator
    implements ObjectPredicate {
        private RefLocator() {
        }

        public boolean check(Object obj) {
            return obj instanceof AggregationRefNode;
        }
    }
}

