/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.MapContext;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class GeneratorLambdaFunctionNode
extends CompositeNode {
    private final TensorType type;
    private final ExpressionNode generator;

    public GeneratorLambdaFunctionNode(TensorType type, ExpressionNode generator) {
        if (!type.dimensions().stream().allMatch(d -> d.size().isPresent())) {
            throw new IllegalArgumentException("A tensor generator function can only generate tensors with bound dimensions, but tried to generate " + type);
        }
        this.type = type;
        this.generator = generator;
    }

    public LongListToDoubleLambda asLongListToDoubleOperator() {
        return new LongListToDoubleLambda();
    }

    @Override
    public List<ExpressionNode> children() {
        return List.of(this.generator);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("A lambda function must have a single child expression");
        }
        return new GeneratorLambdaFunctionNode(this.type, children.get(0));
    }

    @Override
    public StringBuilder toString(StringBuilder string, SerializationContext context, Deque<String> path, CompositeNode parent) {
        return this.generator.toString(string, context, path, this);
    }

    @Override
    public TensorType type(TypeContext<Reference> context) {
        return this.type;
    }

    @Override
    public Value evaluate(Context context) {
        return this.generator.evaluate(context);
    }

    @Override
    public int hashCode() {
        return Objects.hash("generator", this.type, this.generator);
    }

    private class LongListToDoubleLambda
    implements Function<List<Long>, Double> {
        private LongListToDoubleLambda() {
        }

        @Override
        public Double apply(List<Long> arguments) {
            MapContext context = new MapContext();
            for (int i = 0; i < GeneratorLambdaFunctionNode.this.type.dimensions().size(); ++i) {
                context.put(((TensorType.Dimension)GeneratorLambdaFunctionNode.this.type.dimensions().get(i)).name(), arguments.get(i).longValue());
            }
            return GeneratorLambdaFunctionNode.this.evaluate(context).asDouble();
        }

        public String toString() {
            return GeneratorLambdaFunctionNode.this.toString();
        }
    }
}

