/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.AbstractArrayContext;
import com.yahoo.searchlib.rankingexpression.evaluation.ContextIndex;
import com.yahoo.searchlib.rankingexpression.evaluation.OptimizationReport;
import com.yahoo.searchlib.rankingexpression.evaluation.Optimizer;
import com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization.GBDTForestOptimizer;
import com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization.GBDTOptimizer;
import com.yahoo.searchlib.rankingexpression.evaluation.tensoroptimization.TensorOptimizer;

public class ExpressionOptimizer {
    private final GBDTOptimizer gbdtOptimizer = new GBDTOptimizer();
    private final GBDTForestOptimizer gbdtForestOptimizer = new GBDTForestOptimizer();
    private final TensorOptimizer tensorOptimizer = new TensorOptimizer();

    public Optimizer getOptimizer(Class<?> clazz) {
        if (clazz == this.gbdtOptimizer.getClass()) {
            return this.gbdtOptimizer;
        }
        if (clazz == this.gbdtForestOptimizer.getClass()) {
            return this.gbdtForestOptimizer;
        }
        if (clazz == this.tensorOptimizer.getClass()) {
            return this.tensorOptimizer;
        }
        return null;
    }

    public OptimizationReport optimize(RankingExpression expression, ContextIndex contextIndex) {
        OptimizationReport report = new OptimizationReport();
        this.gbdtOptimizer.optimize(expression, contextIndex, report);
        this.gbdtForestOptimizer.optimize(expression, contextIndex, report);
        this.tensorOptimizer.optimize(expression, contextIndex, report);
        return report;
    }

    public OptimizationReport optimize(RankingExpression expression, AbstractArrayContext arrayContext) {
        return this.optimize(expression, (ContextIndex)arrayContext);
    }
}

