/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.gbdt;

import com.yahoo.searchlib.gbdt.FeatureNode;
import com.yahoo.searchlib.gbdt.ResponseNode;
import java.util.Optional;
import org.w3c.dom.Node;

public abstract class TreeNode {
    private final Optional<Integer> samples;

    public TreeNode(Optional<Integer> samples) {
        this.samples = samples;
    }

    public abstract String toRankingExpression();

    public Optional<Integer> samples() {
        return this.samples;
    }

    public static TreeNode fromDom(Node node) {
        String nodeName = node.getNodeName();
        if (nodeName.equalsIgnoreCase("node")) {
            return FeatureNode.fromDom(node);
        }
        if (nodeName.equalsIgnoreCase("response")) {
            return ResponseNode.fromDom(node);
        }
        throw new UnsupportedOperationException(nodeName);
    }

    static Optional<Integer> toInteger(Optional<String> integerText) {
        if (!integerText.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(integerText.get()));
    }
}

