/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.evaluation.DoubleCompatibleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;

public class LongValue
extends DoubleCompatibleValue {
    private final long value;

    public LongValue(long value) {
        this.value = value;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public boolean asBoolean() {
        return this.value != 0L;
    }

    @Override
    public Value asMutable() {
        return new LongValue(this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Value)) {
            return false;
        }
        if (!((Value)other).hasDouble()) {
            return false;
        }
        return new DoubleValue(this.value).equals(other);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public Value negate() {
        return new LongValue(-this.value);
    }

    private UnsupportedOperationException unsupported(String operation, Value value) {
        return new UnsupportedOperationException("Cannot perform " + operation + " on " + value + " and " + this);
    }

    private DoubleValue mutable(double value) {
        return new DoubleValue(value);
    }

    @Override
    public Value add(Value value) {
        if (value instanceof TensorValue) {
            return value.add(this);
        }
        try {
            return this.mutable((double)this.value + value.asDouble());
        }
        catch (UnsupportedOperationException e) {
            throw this.unsupported("add", value);
        }
    }

    @Override
    public Value subtract(Value value) {
        if (value instanceof TensorValue) {
            return value.negate().add(this);
        }
        try {
            return this.mutable((double)this.value - value.asDouble());
        }
        catch (UnsupportedOperationException e) {
            throw this.unsupported("subtract", value);
        }
    }

    @Override
    public Value multiply(Value value) {
        if (value instanceof TensorValue) {
            return value.multiply(this);
        }
        try {
            return this.mutable((double)this.value * value.asDouble());
        }
        catch (UnsupportedOperationException e) {
            throw this.unsupported("multiply", value);
        }
    }

    @Override
    public Value divide(Value value) {
        try {
            return this.mutable((double)this.value / value.asDouble());
        }
        catch (UnsupportedOperationException e) {
            throw this.unsupported("divide", value);
        }
    }

    @Override
    public Value modulo(Value value) {
        try {
            return this.mutable((double)this.value % value.asDouble());
        }
        catch (UnsupportedOperationException e) {
            throw this.unsupported("modulo", value);
        }
    }

    @Override
    public Value function(Function function, Value value) {
        if ((function.equals(Function.min) || function.equals(Function.max)) && value instanceof TensorValue) {
            return value.function(function, this);
        }
        try {
            return this.mutable(function.evaluate(this.value, value.asDouble()));
        }
        catch (UnsupportedOperationException e) {
            throw this.unsupported("function " + function, value);
        }
    }
}

