/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.NumericResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.nio.ByteBuffer;

public class FloatResultNode
extends NumericResultNode {
    public static final int classId = FloatResultNode.registerClass((int)16436, FloatResultNode.class, FloatResultNode::new);
    private static final FloatResultNode negativeInfinity = new FloatResultNode(Double.NEGATIVE_INFINITY);
    private static final FloatResultNode positiveInfinity = new FloatResultNode(Double.POSITIVE_INFINITY);
    private double value;

    public FloatResultNode() {
    }

    public FloatResultNode(double value) {
        this.setValue(value);
    }

    public FloatResultNode setValue(double value) {
        this.value = value;
        return this;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putDouble(null, this.value);
    }

    protected void onDeserialize(Deserializer buf) {
        this.value = buf.getDouble(null);
    }

    @Override
    public long getInteger() {
        return Math.round(this.value);
    }

    @Override
    public double getFloat() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public byte[] getRaw() {
        return ByteBuffer.allocate(8).putDouble(this.value).array();
    }

    @Override
    public void add(ResultNode rhs) {
        this.value += rhs.getFloat();
    }

    @Override
    public void negate() {
        this.value = -this.value;
    }

    @Override
    public void multiply(ResultNode rhs) {
        this.value *= rhs.getFloat();
    }

    @Override
    public void divide(ResultNode rhs) {
        double val = rhs.getFloat();
        this.value = val == 0.0 ? 0.0 : this.value / val;
    }

    @Override
    public void modulo(ResultNode rhs) {
        this.value %= (double)rhs.getInteger();
    }

    @Override
    public void min(ResultNode rhs) {
        double value = rhs.getFloat();
        if (value < this.value) {
            this.value = value;
        }
    }

    @Override
    public void max(ResultNode rhs) {
        double value = rhs.getFloat();
        if (value > this.value) {
            this.value = value;
        }
    }

    @Override
    public Object getNumber() {
        return this.value;
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        double b = rhs.getFloat();
        if (Double.isNaN(this.value)) {
            return Double.isNaN(b) ? 0 : -1;
        }
        if (Double.isNaN(b)) {
            return 1;
        }
        return Double.compare(this.value, b);
    }

    public int hashCode() {
        return super.hashCode() + (int)this.value;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("value", (Object)this.value);
    }

    @Override
    public void set(ResultNode rhs) {
        this.value = rhs.getFloat();
    }

    public static FloatResultNode getNegativeInfinity() {
        return negativeInfinity;
    }

    public static FloatResultNode getPositiveInfinity() {
        return positiveInfinity;
    }
}

