/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ArithmeticOperator {
    OR(0, "||"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.or(y);
        }
    }
    ,
    AND(1, "&&"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.and(y);
        }
    }
    ,
    PLUS(2, "+"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.add(y);
        }
    }
    ,
    MINUS(3, "-"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.subtract(y);
        }
    }
    ,
    MULTIPLY(4, "*"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.multiply(y);
        }
    }
    ,
    DIVIDE(5, "/"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.divide(y);
        }
    }
    ,
    MODULO(6, "%"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.modulo(y);
        }
    }
    ,
    POWER(7, "^"){

        @Override
        public Value evaluate(Value x, Value y) {
            return x.power(y);
        }
    };

    public static final List<ArithmeticOperator> operatorsByPrecedence;
    private final int precedence;
    private final String image;

    private ArithmeticOperator(int precedence, String image) {
        this.precedence = precedence;
        this.image = image;
    }

    public boolean hasPrecedenceOver(ArithmeticOperator op) {
        return this.precedence > op.precedence;
    }

    public abstract Value evaluate(Value var1, Value var2);

    public String toString() {
        return this.image;
    }

    private static List<ArithmeticOperator> operatorsByPrecedence() {
        ArrayList<ArithmeticOperator> operators = new ArrayList<ArithmeticOperator>();
        operators.add(POWER);
        operators.add(MODULO);
        operators.add(DIVIDE);
        operators.add(MULTIPLY);
        operators.add(MINUS);
        operators.add(PLUS);
        operators.add(AND);
        operators.add(OR);
        return Collections.unmodifiableList(operators);
    }

    static {
        operatorsByPrecedence = ArithmeticOperator.operatorsByPrecedence();
    }
}

