/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.expression.IntegerResultNode;
import com.yahoo.searchlib.expression.NumericResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class AverageAggregationResult
extends AggregationResult {
    public static final int classId = AverageAggregationResult.registerClass((int)16469, AverageAggregationResult.class);
    private NumericResultNode sum;
    private long count;

    public AverageAggregationResult() {
    }

    public AverageAggregationResult(NumericResultNode sum, long count) {
        this.setSum(sum);
        this.setCount(count);
    }

    public final NumericResultNode getSum() {
        return this.sum;
    }

    public final AverageAggregationResult setSum(NumericResultNode sum) {
        this.sum = sum;
        return this;
    }

    public final long getCount() {
        return this.count;
    }

    public final AverageAggregationResult setCount(long count) {
        this.count = count;
        return this;
    }

    public final NumericResultNode getAverage() {
        NumericResultNode sum = (NumericResultNode)this.sum.clone();
        if (this.count != 0L) {
            sum.divide(new IntegerResultNode(this.count));
        }
        return sum;
    }

    @Override
    public ResultNode getRank() {
        return this.getAverage();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putLong(null, this.count);
        AverageAggregationResult.serializeOptional((Serializer)buf, (Identifiable)this.sum);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.count = buf.getLong(null);
        this.sum = (NumericResultNode)AverageAggregationResult.deserializeOptional((Deserializer)buf);
    }

    @Override
    protected void onMerge(AggregationResult result) {
        this.sum.add(((AverageAggregationResult)result).sum);
        this.count += ((AverageAggregationResult)result).count;
    }

    @Override
    public AverageAggregationResult clone() {
        AverageAggregationResult obj = (AverageAggregationResult)super.clone();
        if (this.sum != null) {
            obj.sum = (NumericResultNode)this.sum.clone();
        }
        return obj;
    }

    @Override
    protected boolean equalsAggregation(AggregationResult obj) {
        AverageAggregationResult rhs = (AverageAggregationResult)obj;
        if (!AverageAggregationResult.equals((Object)this.sum, (Object)rhs.sum)) {
            return false;
        }
        return this.count == rhs.count;
    }

    public int hashCode() {
        return super.hashCode() + (int)this.count;
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("sum", (Object)this.sum);
        visitor.visit("count", (Object)this.count);
    }
}

