/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.ContextIndex;
import com.yahoo.searchlib.rankingexpression.evaluation.OptimizationReport;
import com.yahoo.searchlib.rankingexpression.evaluation.Optimizer;
import com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization.GBDTForestNode;
import com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization.GBDTNode;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.OperationNode;
import com.yahoo.searchlib.rankingexpression.rule.Operator;
import java.util.ArrayList;
import java.util.List;

public class GBDTForestOptimizer
extends Optimizer {
    private OptimizationReport report;
    private int currentTreesOptimized = 0;

    @Override
    public void optimize(RankingExpression expression, ContextIndex context, OptimizationReport report) {
        if (!this.isEnabled()) {
            return;
        }
        this.report = report;
        expression.setRoot(this.findAndOptimize(expression.getRoot()));
        report.note("GBDT forest optimization done");
    }

    private ExpressionNode findAndOptimize(ExpressionNode node) {
        ExpressionNode newNode = this.optimize(node);
        if (!(newNode instanceof CompositeNode)) {
            return newNode;
        }
        CompositeNode newComposite = (CompositeNode)newNode;
        ArrayList<ExpressionNode> newChildren = new ArrayList<ExpressionNode>();
        for (ExpressionNode child : newComposite.children()) {
            newChildren.add(this.findAndOptimize(child));
        }
        return newComposite.setChildren(newChildren);
    }

    private ExpressionNode optimize(ExpressionNode node) {
        this.currentTreesOptimized = 0;
        ArrayList<Double> forest = new ArrayList<Double>();
        boolean optimized = this.optimize(node, forest);
        if (!optimized) {
            return node;
        }
        GBDTForestNode forestNode = new GBDTForestNode(this.toArray(forest));
        this.report.incMetric("Number of forests", 1);
        this.report.incMetric("GBDT trees optimized to forests", this.currentTreesOptimized);
        return forestNode;
    }

    private boolean optimize(ExpressionNode node, List<Double> forest) {
        if (node instanceof GBDTNode) {
            this.addTo(forest, (GBDTNode)node);
            ++this.currentTreesOptimized;
            return true;
        }
        if (!(node instanceof OperationNode)) {
            return false;
        }
        OperationNode aNode = (OperationNode)node;
        for (Operator op : aNode.operators()) {
            if (op == Operator.plus) continue;
            return false;
        }
        for (ExpressionNode child : aNode.children()) {
            if (this.optimize(child, forest)) continue;
            return false;
        }
        return true;
    }

    private void addTo(List<Double> forest, GBDTNode tree) {
        forest.add(Double.valueOf(tree.values().length));
        this.addAll(tree.values(), forest);
    }

    private void addAll(double[] values, List<Double> forest) {
        for (double value : values) {
            forest.add(value);
        }
    }

    private double[] toArray(List<Double> valueList) {
        double[] valueArray = new double[valueList.size()];
        for (int i = 0; i < valueList.size(); ++i) {
            valueArray[i] = valueList.get(i);
        }
        return valueArray;
    }
}

