/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.BucketResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class IntegerBucketResultNode
extends BucketResultNode {
    public static final int classId = IntegerBucketResultNode.registerClass((int)16485, IntegerBucketResultNode.class);
    private long from = 0L;
    private long to = 0L;

    public IntegerBucketResultNode() {
    }

    public IntegerBucketResultNode(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    @Override
    public boolean empty() {
        return this.to == this.from;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putLong(null, this.from);
        buf.putLong(null, this.to);
    }

    protected void onDeserialize(Deserializer buf) {
        this.from = buf.getLong(null);
        this.to = buf.getLong(null);
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        IntegerBucketResultNode b = (IntegerBucketResultNode)rhs;
        if (this.from < b.from) {
            return -1;
        }
        if (this.from > b.from) {
            return 1;
        }
        if (this.to < b.to) {
            return -1;
        }
        if (this.to > b.to) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        return super.hashCode() + (int)this.from + (int)this.to;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("from", (Object)this.from);
        visitor.visit("to", (Object)this.to);
    }
}

