/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.ContextIndex;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractArrayContext
extends Context
implements Cloneable,
ContextIndex {
    private final boolean ignoreUnknownValues;
    private final String rankingExpressionName;
    private IndexedBindings indexedBindings;

    protected AbstractArrayContext(RankingExpression expression) {
        this(expression, false);
    }

    protected AbstractArrayContext(RankingExpression expression, boolean ignoreUnknownValues) {
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.rankingExpressionName = expression.getName();
        this.indexedBindings = new IndexedBindings(expression);
    }

    protected final Map<String, Integer> nameToIndex() {
        return this.indexedBindings.nameToIndex();
    }

    protected final double[] doubleValues() {
        return this.indexedBindings.doubleValues();
    }

    protected final boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    @Override
    public Set<String> names() {
        return this.indexedBindings.names();
    }

    @Override
    public final int getIndex(String name) {
        return (Integer)this.indexedBindings.nameToIndex.get((Object)name);
    }

    @Override
    public int size() {
        return this.indexedBindings.size();
    }

    @Override
    public double getDouble(int index) {
        return this.indexedBindings.getDouble(index);
    }

    public String toString() {
        return "fast lookup context for ranking expression '" + this.rankingExpressionName + "' [" + this.size() + " variables]";
    }

    public AbstractArrayContext clone() {
        try {
            AbstractArrayContext clone = (AbstractArrayContext)super.clone();
            clone.indexedBindings = this.indexedBindings.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    private static class IndexedBindings
    implements Cloneable {
        private final ImmutableMap<String, Integer> nameToIndex;
        private double[] doubleValues;

        public IndexedBindings(RankingExpression expression) {
            LinkedHashSet<String> bindTargets = new LinkedHashSet<String>();
            this.extractBindTargets(expression.getRoot(), bindTargets);
            this.doubleValues = new double[bindTargets.size()];
            int i = 0;
            ImmutableMap.Builder nameToIndexBuilder = new ImmutableMap.Builder();
            for (String variable : bindTargets) {
                nameToIndexBuilder.put((Object)variable, (Object)i++);
            }
            this.nameToIndex = nameToIndexBuilder.build();
        }

        private void extractBindTargets(ExpressionNode node, Set<String> bindTargets) {
            if (node instanceof ReferenceNode) {
                if (((ReferenceNode)node).getArguments().expressions().size() > 0) {
                    throw new UnsupportedOperationException("Can not bind " + node + ": Array lookup is not supported with features having arguments)");
                }
                bindTargets.add(node.toString());
            } else if (node instanceof CompositeNode) {
                CompositeNode cNode = (CompositeNode)node;
                for (ExpressionNode child : cNode.children()) {
                    this.extractBindTargets(child, bindTargets);
                }
            }
        }

        public Map<String, Integer> nameToIndex() {
            return this.nameToIndex;
        }

        public double[] doubleValues() {
            return this.doubleValues;
        }

        public Set<String> names() {
            return this.nameToIndex.keySet();
        }

        public int getIndex(String name) {
            return (Integer)this.nameToIndex.get((Object)name);
        }

        public int size() {
            return this.doubleValues.length;
        }

        public double getDouble(int index) {
            return this.doubleValues[index];
        }

        public IndexedBindings clone() {
            try {
                IndexedBindings clone = (IndexedBindings)super.clone();
                clone.doubleValues = new double[this.nameToIndex.size()];
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException("Programming error");
            }
        }
    }
}

