/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.AttributeNode;
import com.yahoo.searchlib.expression.FunctionNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.Objects;

public class AttributeMapLookupNode
extends AttributeNode {
    public static final int classId = AttributeMapLookupNode.registerClass((int)16529, AttributeMapLookupNode.class);
    private String keyAttribute = "";
    private String valueAttribute = "";
    private String key = "";
    private String keySourceAttribute = "";

    private AttributeMapLookupNode(String attributeExpression, String keyAttribute, String valueAttribute, String key, String keySourceAttribute) {
        super(attributeExpression);
        this.keyAttribute = keyAttribute;
        this.valueAttribute = valueAttribute;
        this.key = key;
        this.keySourceAttribute = keySourceAttribute;
    }

    public AttributeMapLookupNode() {
    }

    public static AttributeMapLookupNode fromKey(String attributeExpression, String keyAttribute, String valueAttribute, String key) {
        return new AttributeMapLookupNode(attributeExpression, keyAttribute, valueAttribute, key, "");
    }

    public static AttributeMapLookupNode fromKeySourceAttribute(String attributeExpression, String keyAttribute, String valueAttribute, String keySourceAttribute) {
        return new AttributeMapLookupNode(attributeExpression, keyAttribute, valueAttribute, "", keySourceAttribute);
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    @Override
    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        this.putUtf8(buf, this.keyAttribute);
        this.putUtf8(buf, this.valueAttribute);
        this.putUtf8(buf, this.key);
        this.putUtf8(buf, this.keySourceAttribute);
    }

    @Override
    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.keyAttribute = this.getUtf8(buf);
        this.valueAttribute = this.getUtf8(buf);
        this.key = this.getUtf8(buf);
        this.keySourceAttribute = this.getUtf8(buf);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.keyAttribute, this.valueAttribute, this.key, this.keySourceAttribute);
    }

    @Override
    protected boolean equalsFunction(FunctionNode obj) {
        AttributeMapLookupNode that = (AttributeMapLookupNode)obj;
        return super.equalsFunction(obj) && Objects.equals(this.keyAttribute, that.keyAttribute) && Objects.equals(this.valueAttribute, that.valueAttribute) && Objects.equals(this.key, that.key) && Objects.equals(this.keySourceAttribute, that.keySourceAttribute);
    }

    @Override
    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("keyAttribute", (Object)this.keyAttribute);
        visitor.visit("valueAttribute", (Object)this.valueAttribute);
        visitor.visit("key", (Object)this.key);
        visitor.visit("keySourceAttribute", (Object)this.keySourceAttribute);
    }
}

