/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.searchlib.expression.StringBucketResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class StringBucketResultNodeVector
extends ResultNodeVector {
    public static final int classId = StringBucketResultNodeVector.registerClass((int)16498, StringBucketResultNodeVector.class);
    private ArrayList<StringBucketResultNode> vector = new ArrayList();

    @Override
    protected int onGetClassId() {
        return classId;
    }

    public StringBucketResultNodeVector add(StringBucketResultNode v) {
        this.vector.add(v);
        return this;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((StringBucketResultNode)r);
    }

    public ArrayList<StringBucketResultNode> getVector() {
        return this.vector;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (StringBucketResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            StringBucketResultNode node = new StringBucketResultNode();
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        StringBucketResultNodeVector b = (StringBucketResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

