/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.aggregation;

import com.yahoo.searchlib.aggregation.AggregationResult;
import com.yahoo.searchlib.aggregation.GroupingLevel;
import com.yahoo.searchlib.expression.AggregationRefNode;
import com.yahoo.searchlib.expression.ExpressionNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectOperation;
import com.yahoo.vespa.objects.ObjectPredicate;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Group
extends Identifiable {
    public static final int classId = Group.registerClass((int)16474, Group.class);
    private static final ObjectPredicate REF_LOCATOR = new RefLocator();
    private List<Integer> orderByIdx = new ArrayList<Integer>();
    private List<ExpressionNode> orderByExp = new ArrayList<ExpressionNode>();
    private List<AggregationResult> aggregationResults = new ArrayList<AggregationResult>();
    private List<Group> children = new ArrayList<Group>();
    private ResultNode id = null;
    private double rank;
    private int tag = -1;
    private SortType sortType = SortType.UNSORTED;

    public boolean isRankedByRelevance() {
        return this.orderByIdx.isEmpty();
    }

    public void merge(int firstLevel, int currentLevel, Group rhs) {
        if (rhs.rank > this.rank) {
            this.rank = rhs.rank;
        }
        if (currentLevel >= firstLevel) {
            int len = this.aggregationResults.size();
            for (int i = 0; i < len; ++i) {
                this.aggregationResults.get(i).merge(rhs.aggregationResults.get(i));
            }
        }
        ArrayList<Group> merged = new ArrayList<Group>();
        Iterator<Group> lhsChild = this.children.iterator();
        Iterator<Group> rhsChild = rhs.children.iterator();
        if (lhsChild.hasNext() && rhsChild.hasNext()) {
            Group lhsGroup = lhsChild.next();
            Group rhsGroup = rhsChild.next();
            while (lhsGroup != null && rhsGroup != null) {
                int cmp = lhsGroup.getId().compareTo(rhsGroup.getId());
                if (cmp < 0) {
                    merged.add(lhsGroup);
                    lhsGroup = lhsChild.hasNext() ? lhsChild.next() : null;
                    continue;
                }
                if (cmp > 0) {
                    merged.add(rhsGroup);
                    rhsGroup = rhsChild.hasNext() ? rhsChild.next() : null;
                    continue;
                }
                lhsGroup.merge(firstLevel, currentLevel + 1, rhsGroup);
                merged.add(lhsGroup);
                lhsGroup = lhsChild.hasNext() ? lhsChild.next() : null;
                rhsGroup = rhsChild.hasNext() ? rhsChild.next() : null;
            }
            if (lhsGroup != null) {
                merged.add(lhsGroup);
            }
            if (rhsGroup != null) {
                merged.add(rhsGroup);
            }
        }
        while (lhsChild.hasNext()) {
            merged.add(lhsChild.next());
        }
        while (rhsChild.hasNext()) {
            merged.add(rhsChild.next());
        }
        this.children = merged;
    }

    private void executeOrderBy() {
        for (ExpressionNode node : this.orderByExp) {
            node.prepare();
            node.execute();
        }
    }

    public void postMerge(List<GroupingLevel> levels, int firstLevel, int currentLevel) {
        if (currentLevel >= firstLevel) {
            for (AggregationResult aggregationResult : this.aggregationResults) {
                aggregationResult.postMerge();
            }
            for (ExpressionNode expressionNode : this.orderByExp) {
                expressionNode.execute();
            }
        }
        if (currentLevel < levels.size()) {
            int maxGroups = (int)levels.get(currentLevel).getMaxGroups();
            for (Group group : this.children) {
                group.executeOrderBy();
            }
            if (maxGroups >= 0 && this.children.size() > maxGroups) {
                this.sortChildrenByRank();
                this.children = this.children.subList(0, maxGroups);
                this.sortChildrenById();
            }
            for (Group group : this.children) {
                group.postMerge(levels, firstLevel, currentLevel + 1);
            }
        }
    }

    public void sortChildrenById() {
        if (this.sortType == SortType.BYID) {
            return;
        }
        Collections.sort(this.children, (lhs, rhs) -> lhs.compareId((Group)((Object)rhs)));
        this.sortType = SortType.BYID;
    }

    public void sortChildrenByRank() {
        if (this.sortType == SortType.BYRANK) {
            return;
        }
        Collections.sort(this.children, (lhs, rhs) -> lhs.compareRank((Group)((Object)rhs)));
        this.sortType = SortType.BYRANK;
    }

    public ResultNode getId() {
        return this.id;
    }

    public Group setId(ResultNode id) {
        this.id = id;
        return this;
    }

    public Group setRank(double rank) {
        this.rank = rank;
        return this;
    }

    public double getRank() {
        return this.rank;
    }

    public Group addChild(Group child) {
        if (child == null) {
            throw new IllegalArgumentException("Child can not be null.");
        }
        this.children.add(child);
        return this;
    }

    public List<Group> getChildren() {
        return this.children;
    }

    public int getTag() {
        return this.tag;
    }

    public Group setTag(int tag) {
        this.tag = tag;
        return this;
    }

    public List<AggregationResult> getAggregationResults() {
        return this.aggregationResults;
    }

    public Group addAggregationResult(AggregationResult result) {
        this.aggregationResults.add(result);
        return this;
    }

    public Group addOrderBy(ExpressionNode exp, boolean asc) {
        if (exp instanceof AggregationResult) {
            exp = new AggregationRefNode((AggregationResult)exp);
        }
        exp.select(REF_LOCATOR, new RefResolver(this));
        this.orderByExp.add(exp);
        this.orderByIdx.add((asc ? 1 : -1) * this.orderByExp.size());
        return this;
    }

    public List<Integer> getOrderByIndexes() {
        return Collections.unmodifiableList(this.orderByIdx);
    }

    public List<ExpressionNode> getOrderByExpressions() {
        return Collections.unmodifiableList(this.orderByExp);
    }

    private int compareId(Group rhs) {
        return this.getId().compareTo(rhs.getId());
    }

    private int compareRank(Group rhs) {
        int rawIndex;
        long diff = 0L;
        int m = this.orderByIdx.size();
        for (int i = 0; diff == 0L && i < m; diff *= (long)rawIndex, ++i) {
            rawIndex = this.orderByIdx.get(i);
            int index = (rawIndex < 0 ? -rawIndex : rawIndex) - 1;
            diff = this.orderByExp.get(index).getResult().compareTo(rhs.orderByExp.get(index).getResult());
        }
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return -Double.compare(this.rank, rhs.rank);
    }

    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        Group.serializeOptional((Serializer)buf, (Identifiable)this.id);
        buf.putDouble(null, this.rank);
        int sz = this.orderByIdx.size();
        buf.putInt(null, sz);
        for (Integer n : this.orderByIdx) {
            buf.putInt(null, n.intValue());
        }
        int numResults = this.aggregationResults.size();
        buf.putInt(null, numResults);
        for (AggregationResult aggregationResult : this.aggregationResults) {
            Group.serializeOptional((Serializer)buf, (Identifiable)aggregationResult);
        }
        int n = this.orderByExp.size();
        buf.putInt(null, n);
        for (ExpressionNode e : this.orderByExp) {
            Group.serializeOptional((Serializer)buf, (Identifiable)e);
        }
        int n2 = this.children.size();
        buf.putInt(null, n2);
        for (Group g : this.children) {
            g.serializeWithId(buf);
        }
        buf.putInt(null, this.tag);
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        this.id = (ResultNode)Group.deserializeOptional((Deserializer)buf);
        this.rank = buf.getDouble(null);
        this.orderByIdx.clear();
        int orderByCount = buf.getInt(null);
        for (int i = 0; i < orderByCount; ++i) {
            this.orderByIdx.add(buf.getInt(null));
        }
        int numResults = buf.getInt(null);
        for (int i = 0; i < numResults; ++i) {
            AggregationResult e = (AggregationResult)Group.deserializeOptional((Deserializer)buf);
            this.aggregationResults.add(e);
        }
        int numExpressionResults = buf.getInt(null);
        RefResolver resolver = new RefResolver(this);
        for (int i = 0; i < numExpressionResults; ++i) {
            ExpressionNode exp = (ExpressionNode)Group.deserializeOptional((Deserializer)buf);
            exp.select(REF_LOCATOR, resolver);
            this.orderByExp.add(exp);
        }
        int numGroups = buf.getInt(null);
        for (int i = 0; i < numGroups; ++i) {
            Group g = new Group();
            g.deserializeWithId(buf);
            this.children.add(g);
        }
        this.tag = buf.getInt(null);
    }

    public int hashCode() {
        return super.hashCode() + this.aggregationResults.hashCode() + this.children.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Group rhs = (Group)((Object)obj);
        if (!Group.equals((Object)this.id, (Object)rhs.id)) {
            return false;
        }
        if (this.rank != rhs.rank) {
            return false;
        }
        if (!this.aggregationResults.equals(rhs.aggregationResults)) {
            return false;
        }
        if (!this.orderByIdx.equals(rhs.orderByIdx)) {
            return false;
        }
        if (!this.orderByExp.equals(rhs.orderByExp)) {
            return false;
        }
        return this.children.equals(rhs.children);
    }

    public Group clone() {
        Group obj = (Group)super.clone();
        if (this.id != null) {
            obj.id = (ResultNode)this.id.clone();
        }
        obj.aggregationResults = new ArrayList<AggregationResult>();
        for (AggregationResult result : this.aggregationResults) {
            obj.aggregationResults.add(result.clone());
        }
        obj.orderByIdx = new ArrayList<Integer>(this.orderByIdx);
        obj.orderByExp = new ArrayList<ExpressionNode>();
        RefResolver resolver = new RefResolver(obj);
        for (ExpressionNode exp : this.orderByExp) {
            exp = exp.clone();
            exp.select(REF_LOCATOR, resolver);
            obj.orderByExp.add(exp);
        }
        obj.children = new ArrayList<Group>();
        for (Group child : this.children) {
            obj.children.add(child.clone());
        }
        return obj;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("id", (Object)this.id);
        visitor.visit("rank", (Object)this.rank);
        visitor.visit("aggregationresults", this.aggregationResults);
        visitor.visit("orderby-idx", this.orderByIdx);
        visitor.visit("orderby-exp", this.orderByExp);
        visitor.visit("children", this.children);
        visitor.visit("tag", (Object)this.tag);
    }

    public void selectMembers(ObjectPredicate predicate, ObjectOperation operation) {
        for (AggregationResult result : this.aggregationResults) {
            result.select(predicate, operation);
        }
        for (ExpressionNode exp : this.orderByExp) {
            exp.select(predicate, operation);
        }
    }

    private static class RefResolver
    implements ObjectOperation {
        final List<AggregationResult> results;

        RefResolver(Group group) {
            this.results = group.aggregationResults;
        }

        public void execute(Object obj) {
            AggregationRefNode ref = (AggregationRefNode)obj;
            int idx = ref.getIndex();
            if (idx < 0) {
                AggregationResult res = ref.getExpression();
                idx = this.indexOf(res);
                if (idx < 0) {
                    idx = this.results.size();
                    this.results.add(res);
                }
                ref.setIndex(idx);
            } else {
                ref.setExpression(this.results.get(idx));
            }
        }

        int indexOf(AggregationResult lhs) {
            int prevTag = lhs.getTag();
            int len = this.results.size();
            for (int i = 0; i < len; ++i) {
                AggregationResult rhs = this.results.get(i);
                lhs.setTag(rhs.getTag());
                if (!lhs.equals(rhs)) continue;
                return i;
            }
            lhs.setTag(prevTag);
            return -1;
        }
    }

    private static class RefLocator
    implements ObjectPredicate {
        private RefLocator() {
        }

        public boolean check(Object obj) {
            return obj instanceof AggregationRefNode;
        }
    }

    private static enum SortType {
        UNSORTED,
        BYRANK,
        BYID;

    }
}

