/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OptimizationReport {
    private Map<String, Integer> metrics = new LinkedHashMap<String, Integer>();
    private List<String> notes = new ArrayList<String>();

    public void setMetric(String name, int value) {
        this.metrics.put(name, value);
    }

    public int getMetric(String name) {
        return this.metrics.get(name);
    }

    public void incMetric(String name, int increment) {
        Integer currentValue = this.metrics.get(name);
        if (currentValue == null) {
            currentValue = 0;
        }
        this.metrics.put(name, currentValue + increment);
    }

    public void note(String note) {
        this.notes.add(note);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.notes.size() > 0) {
            b.append("Optimization notes:\n");
            List<String> displayedNotes = this.notes.subList(0, Math.min(5, this.notes.size()));
            for (String note : displayedNotes) {
                b.append("   ").append(note).append("\n");
            }
            if (this.notes.size() > displayedNotes.size()) {
                b.append("   ...\n");
            }
        }
        b.append("Optimization metrics:\n");
        for (Map.Entry<String, Integer> metric : this.metrics.entrySet()) {
            b.append("   " + metric.getKey() + ": " + metric.getValue() + "\n");
        }
        return b.toString();
    }
}

