/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features.fieldmatch;

import com.google.common.collect.ImmutableList;
import java.util.List;

public class Field {
    private final ImmutableList<Term> terms;

    public Field(String fieldString) {
        ImmutableList.Builder list = new ImmutableList.Builder();
        for (String term : fieldString.split(" ")) {
            list.add((Object)new Term(term));
        }
        this.terms = list.build();
    }

    public Field(List<Term> terms) {
        this.terms = ImmutableList.copyOf(terms);
    }

    public List<Term> terms() {
        return this.terms;
    }

    public static class Term {
        private final String value;
        private final float exactness;

        public Term(String value) {
            this(value, 1.0f);
        }

        public Term(String value, float exactness) {
            this.value = value;
            this.exactness = exactness;
        }

        public String value() {
            return this.value;
        }

        public float exactness() {
            return this.exactness;
        }
    }
}

