/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.BucketResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.StringResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Identifiable;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;

public class StringBucketResultNode
extends BucketResultNode {
    public static final int classId = StringBucketResultNode.registerClass((int)16487, StringBucketResultNode.class);
    private ResultNode from = StringResultNode.getNegativeInfinity();
    private ResultNode to = StringResultNode.getNegativeInfinity();

    @Override
    public boolean empty() {
        return this.to.equals(this.from);
    }

    public StringBucketResultNode() {
    }

    public StringBucketResultNode(ResultNode from, ResultNode to) {
        this.from = from;
        this.to = to;
    }

    public StringBucketResultNode(String from, String to) {
        this(new StringResultNode(from), new StringResultNode(to));
    }

    public String getFrom() {
        return this.from.getString();
    }

    public String getTo() {
        return this.to.getString();
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        StringBucketResultNode.serializeOptional((Serializer)buf, (Identifiable)this.from);
        StringBucketResultNode.serializeOptional((Serializer)buf, (Identifiable)this.to);
    }

    protected void onDeserialize(Deserializer buf) {
        this.from = (ResultNode)StringBucketResultNode.deserializeOptional((Deserializer)buf);
        this.to = (ResultNode)StringBucketResultNode.deserializeOptional((Deserializer)buf);
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        StringBucketResultNode b = (StringBucketResultNode)rhs;
        int diff = this.from.compareTo(b.from);
        return diff == 0 ? this.to.compareTo(b.to) : diff;
    }

    public int hashCode() {
        return super.hashCode() + this.from.hashCode() + this.to.hashCode();
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("from", (Object)this.from);
        visitor.visit("to", (Object)this.to);
    }
}

