/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashSet;
import java.util.Set;

public final class TranslogserverConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "ff97c688b07b18d582aaa1085068bc10";
    public static final String CONFIG_DEF_NAME = "translogserver";
    public static final String CONFIG_DEF_NAMESPACE = "searchlib";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=searchlib", "listenport int default=13700 restart", "filesizemax int default=50000000 restart", "servername string default=\"tls\" restart", "basedir string default=\"tmp\" restart", "usefsync bool default=false restart", "maxthreads int default=4 restart", "crcmethod enum {ccitt_crc32, xxh64} default=xxh64"};
    private final IntegerNode listenport;
    private final IntegerNode filesizemax;
    private final StringNode servername;
    private final StringNode basedir;
    private final BooleanNode usefsync;
    private final IntegerNode maxthreads;
    private final Crcmethod crcmethod;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public TranslogserverConfig(Builder builder) {
        this(builder, true);
    }

    private TranslogserverConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for translogserver must be initialized: " + builder.__uninitialized);
        }
        this.listenport = builder.listenport == null ? new IntegerNode(13700) : new IntegerNode(builder.listenport.intValue());
        this.filesizemax = builder.filesizemax == null ? new IntegerNode(50000000) : new IntegerNode(builder.filesizemax.intValue());
        this.servername = builder.servername == null ? new StringNode("tls") : new StringNode(builder.servername);
        this.basedir = builder.basedir == null ? new StringNode("tmp") : new StringNode(builder.basedir);
        this.usefsync = builder.usefsync == null ? new BooleanNode(false) : new BooleanNode(builder.usefsync.booleanValue());
        this.maxthreads = builder.maxthreads == null ? new IntegerNode(4) : new IntegerNode(builder.maxthreads.intValue());
        this.crcmethod = builder.crcmethod == null ? new Crcmethod(Crcmethod.xxh64) : new Crcmethod(builder.crcmethod);
    }

    public int listenport() {
        return this.listenport.value();
    }

    public int filesizemax() {
        return this.filesizemax.value();
    }

    public String servername() {
        return this.servername.value();
    }

    public String basedir() {
        return this.basedir.value();
    }

    public boolean usefsync() {
        return this.usefsync.value();
    }

    public int maxthreads() {
        return this.maxthreads.value();
    }

    public Crcmethod.Enum crcmethod() {
        return (Crcmethod.Enum)((Object)this.crcmethod.value());
    }

    private ChangesRequiringRestart getChangesRequiringRestart(TranslogserverConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.listenport, (Node)newConfig.listenport, "listenport", "Port number to use for listening.");
        changes.compare((Node)this.filesizemax, (Node)newConfig.filesizemax, "filesizemax", "Max file size (50M)");
        changes.compare((Node)this.servername, (Node)newConfig.servername, "servername", "Server name to identify server.");
        changes.compare((Node)this.basedir, (Node)newConfig.basedir, "basedir", "Base directory. The default is not used as it is decided by the model.");
        changes.compare((Node)this.usefsync, (Node)newConfig.usefsync, "usefsync", "Use fsync after each commit.\nIf not the below interval is used.");
        changes.compare((Node)this.maxthreads, (Node)newConfig.maxthreads, "maxthreads", "Number of threads available for visiting/subscription.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Crcmethod
    extends EnumNode<Enum> {
        public static final Enum ccitt_crc32 = Enum.ccitt_crc32;
        public static final Enum xxh64 = Enum.xxh64;

        public Crcmethod() {
            this.value = null;
        }

        public Crcmethod(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(@NonNull String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            ccitt_crc32,
            xxh64;

        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer listenport = null;
        private Integer filesizemax = null;
        private String servername = null;
        private String basedir = null;
        private Boolean usefsync = null;
        private Integer maxthreads = null;
        private Crcmethod.Enum crcmethod = null;

        public Builder() {
        }

        public Builder(TranslogserverConfig config) {
            this.listenport(config.listenport());
            this.filesizemax(config.filesizemax());
            this.servername(config.servername());
            this.basedir(config.basedir());
            this.usefsync(config.usefsync());
            this.maxthreads(config.maxthreads());
            this.crcmethod(config.crcmethod());
        }

        private Builder override(Builder __superior) {
            if (__superior.listenport != null) {
                this.listenport(__superior.listenport);
            }
            if (__superior.filesizemax != null) {
                this.filesizemax(__superior.filesizemax);
            }
            if (__superior.servername != null) {
                this.servername(__superior.servername);
            }
            if (__superior.basedir != null) {
                this.basedir(__superior.basedir);
            }
            if (__superior.usefsync != null) {
                this.usefsync(__superior.usefsync);
            }
            if (__superior.maxthreads != null) {
                this.maxthreads(__superior.maxthreads);
            }
            if (__superior.crcmethod != null) {
                this.crcmethod(__superior.crcmethod);
            }
            return this;
        }

        public Builder listenport(int __value) {
            this.listenport = __value;
            return this;
        }

        private Builder listenport(String __value) {
            return this.listenport(Integer.valueOf(__value));
        }

        public Builder filesizemax(int __value) {
            this.filesizemax = __value;
            return this;
        }

        private Builder filesizemax(String __value) {
            return this.filesizemax(Integer.valueOf(__value));
        }

        public Builder servername(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.servername = __value;
            return this;
        }

        public Builder basedir(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.basedir = __value;
            return this;
        }

        public Builder usefsync(boolean __value) {
            this.usefsync = __value;
            return this;
        }

        private Builder usefsync(String __value) {
            return this.usefsync(Boolean.valueOf(__value));
        }

        public Builder maxthreads(int __value) {
            this.maxthreads = __value;
            return this;
        }

        private Builder maxthreads(String __value) {
            return this.maxthreads(Integer.valueOf(__value));
        }

        public Builder crcmethod(Crcmethod.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.crcmethod = __value;
            return this;
        }

        private Builder crcmethod(String __value) {
            return this.crcmethod(Crcmethod.Enum.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return TranslogserverConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return TranslogserverConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return TranslogserverConfig.CONFIG_DEF_NAMESPACE;
        }

        public TranslogserverConfig build() {
            return new TranslogserverConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

