/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.treenet.rule;

import com.yahoo.searchlib.treenet.rule.Response;
import com.yahoo.searchlib.treenet.rule.TreeNet;
import com.yahoo.searchlib.treenet.rule.TreeNode;
import java.util.Map;

public class Tree {
    private final String name;
    private TreeNet parent;
    private String next;
    private final Double value;
    private final String begin;
    private final Map<String, TreeNode> nodes;

    public Tree(String name, Double value, String begin, Map<String, TreeNode> nodes) {
        this.name = name;
        this.value = value;
        this.begin = begin;
        this.nodes = nodes;
        this.next = null;
        for (TreeNode node : this.nodes.values()) {
            node.setParent(this);
            if (!(node instanceof Response)) continue;
            String next = ((Response)node).getNext();
            if (this.next == null) {
                this.next = next;
                continue;
            }
            if (this.next.equals(next)) continue;
            throw new IllegalStateException("Not all child nodes of tree '" + name + "' agree on the next tree to run. Initial name was '" + this.next + "', conflicting name is '" + next + "'.");
        }
    }

    public String getName() {
        return this.name;
    }

    public TreeNet getParent() {
        return this.parent;
    }

    public Tree setParent(TreeNet parent) {
        this.parent = parent;
        return this;
    }

    public String getNext() {
        return this.next;
    }

    public Double getValue() {
        return this.value;
    }

    public String getBegin() {
        return this.begin;
    }

    public Map<String, TreeNode> getNodes() {
        return this.nodes;
    }

    public String toRankingExpression() {
        return this.nodes.get(this.begin).toRankingExpression();
    }
}

