/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.FloatBucketResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.searchlib.expression.ResultNodeVector;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.Serializer;
import java.util.ArrayList;

public class FloatBucketResultNodeVector
extends ResultNodeVector {
    public static final int classId = FloatBucketResultNodeVector.registerClass((int)16497, FloatBucketResultNodeVector.class);
    private ArrayList<FloatBucketResultNode> vector = new ArrayList();

    @Override
    protected int onGetClassId() {
        return classId;
    }

    public FloatBucketResultNodeVector add(FloatBucketResultNode v) {
        this.vector.add(v);
        return this;
    }

    @Override
    public ResultNodeVector add(ResultNode r) {
        return this.add((FloatBucketResultNode)r);
    }

    public ArrayList<FloatBucketResultNode> getVector() {
        return this.vector;
    }

    protected void onSerialize(Serializer buf) {
        super.onSerialize(buf);
        buf.putInt(null, this.vector.size());
        for (FloatBucketResultNode node : this.vector) {
            node.serialize(buf);
        }
    }

    protected void onDeserialize(Deserializer buf) {
        super.onDeserialize(buf);
        int sz = buf.getInt(null);
        this.vector = new ArrayList();
        for (int i = 0; i < sz; ++i) {
            FloatBucketResultNode node = new FloatBucketResultNode(0.0, 0.0);
            node.deserialize(buf);
            this.vector.add(node);
        }
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        if (classId != rhs.getClassId()) {
            return classId - rhs.getClassId();
        }
        FloatBucketResultNodeVector b = (FloatBucketResultNodeVector)rhs;
        int minLength = this.vector.size();
        if (b.vector.size() < minLength) {
            minLength = b.vector.size();
        }
        int diff = 0;
        for (int i = 0; diff == 0 && i < minLength; ++i) {
            diff = this.vector.get(i).compareTo(b.vector.get(i));
        }
        return diff == 0 ? this.vector.size() - b.vector.size() : diff;
    }
}

