/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.expression;

import com.yahoo.searchlib.expression.NumericResultNode;
import com.yahoo.searchlib.expression.ResultNode;
import com.yahoo.vespa.objects.Deserializer;
import com.yahoo.vespa.objects.ObjectVisitor;
import com.yahoo.vespa.objects.Serializer;
import java.nio.ByteBuffer;

public class Int32ResultNode
extends NumericResultNode {
    public static final int classId = Int32ResultNode.registerClass((int)16490, Int32ResultNode.class);
    private int value = 0;

    public Int32ResultNode() {
    }

    public Int32ResultNode(int value) {
        this.value = value;
    }

    public Int32ResultNode setValue(int value) {
        this.value = value;
        return this;
    }

    @Override
    protected int onGetClassId() {
        return classId;
    }

    protected void onSerialize(Serializer buf) {
        buf.putInt(null, this.value);
    }

    protected void onDeserialize(Deserializer buf) {
        this.value = buf.getInt(null);
    }

    @Override
    public long getInteger() {
        return this.value;
    }

    @Override
    public double getFloat() {
        return this.value;
    }

    @Override
    public String getString() {
        return String.valueOf(this.value);
    }

    @Override
    public byte[] getRaw() {
        return ByteBuffer.allocate(8).putLong(this.value).array();
    }

    @Override
    public void add(ResultNode rhs) {
        this.value = (int)((long)this.value + rhs.getInteger());
    }

    @Override
    public void negate() {
        this.value = -this.value;
    }

    @Override
    public void multiply(ResultNode rhs) {
        this.value = (int)((long)this.value * rhs.getInteger());
    }

    @Override
    public void divide(ResultNode rhs) {
        int val = (int)rhs.getInteger();
        this.value = val == 0 ? 0 : this.value / val;
    }

    @Override
    public void modulo(ResultNode rhs) {
        this.value = (int)((long)this.value % rhs.getInteger());
    }

    @Override
    public void min(ResultNode rhs) {
        int value = (int)rhs.getInteger();
        if (value < this.value) {
            this.value = value;
        }
    }

    @Override
    public void max(ResultNode rhs) {
        int value = (int)rhs.getInteger();
        if (value > this.value) {
            this.value = value;
        }
    }

    @Override
    public Object getNumber() {
        return this.value;
    }

    @Override
    protected int onCmp(ResultNode rhs) {
        long value = rhs.getInteger();
        return (long)this.value < value ? -1 : ((long)this.value > value ? 1 : 0);
    }

    public int hashCode() {
        return super.hashCode() + this.value;
    }

    public void visitMembers(ObjectVisitor visitor) {
        super.visitMembers(visitor);
        visitor.visit("value", (Object)this.value);
    }

    @Override
    public void set(ResultNode rhs) {
        this.value = (int)rhs.getInteger();
    }
}

