/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml.importer.operations;

import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.DimensionRenamer;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.OrderedTensorType;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.operations.IntermediateOperation;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.TensorFunctionNode;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.functions.TensorFunction;
import java.util.List;
import java.util.Optional;

public class Const
extends IntermediateOperation {
    private final IntermediateOperation.AttributeMap attributeMap;

    public Const(String modelName, String nodeName, List<IntermediateOperation> inputs, IntermediateOperation.AttributeMap attributeMap, OrderedTensorType type) {
        super(modelName, nodeName, inputs);
        this.attributeMap = attributeMap;
        this.type = type.rename(this.vespaName() + "_");
        this.setConstantValue(this.value());
    }

    @Override
    protected OrderedTensorType lazyGetType() {
        return this.type;
    }

    @Override
    public Optional<TensorFunction> function() {
        if (this.function == null) {
            this.function = this.lazyGetFunction();
        }
        return Optional.ofNullable(this.function);
    }

    @Override
    protected TensorFunction lazyGetFunction() {
        ExpressionNode expressionNode = this.type.type().rank() == 0 && this.getConstantValue().isPresent() ? new ConstantNode(this.getConstantValue().get().asDoubleValue()) : new ReferenceNode(Reference.simple("constant", this.vespaName()));
        return new TensorFunctionNode.TensorFunctionExpressionNode(expressionNode);
    }

    @Override
    public String vespaName() {
        return this.modelName + "_" + super.vespaName();
    }

    @Override
    public void addDimensionNameConstraints(DimensionRenamer renamer) {
        for (TensorType.Dimension dimension : this.type.type().dimensions()) {
            renamer.addDimension(dimension.name());
        }
    }

    @Override
    public void renameDimensions(DimensionRenamer renamer) {
        super.renameDimensions(renamer);
        this.setConstantValue(this.value());
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    private Value value() {
        Optional<Value> value = this.attributeMap.get("value", this.type);
        if (!value.isPresent()) {
            throw new IllegalArgumentException("Node '" + this.name + "' of type const has missing or non-recognized 'value' attribute");
        }
        return value.get();
    }
}

