/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features.fieldmatch;

import com.yahoo.searchlib.ranking.features.fieldmatch.FieldMatchMetricsComputer;
import com.yahoo.searchlib.ranking.features.fieldmatch.Trace;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class FieldMatchMetrics
implements Cloneable {
    private FieldMatchMetricsComputer source;
    private final Trace trace = new Trace();
    private boolean complete = false;
    private int outOfOrder;
    private int segments;
    private int gaps;
    private int gapLength;
    private int longestSequence;
    private int head;
    private int tail;
    private int matches;
    private float proximity;
    private float unweightedProximity;
    private float segmentDistance;
    private int pairs;
    private float weight;
    private float significance;
    private float occurrence;
    private float weightedOccurrence;
    private float absoluteOccurrence;
    private float weightedAbsoluteOccurrence;
    private float significantOccurrence;
    private float weightedExactnessSum;
    private int weightSum;
    private int currentSequence;
    private List<Integer> segmentStarts = new ArrayList<Integer>();
    private int queryLength;

    public FieldMatchMetrics(FieldMatchMetricsComputer source) {
        this.source = source;
        this.complete = false;
        this.outOfOrder = 0;
        this.segments = 0;
        this.gaps = 0;
        this.gapLength = 0;
        this.longestSequence = 1;
        this.head = -1;
        this.tail = -1;
        this.proximity = 0.0f;
        this.unweightedProximity = 0.0f;
        this.segmentDistance = 0.0f;
        this.matches = 0;
        this.pairs = 0;
        this.weight = 0.0f;
        this.significance = 0.0f;
        this.weightedExactnessSum = 0.0f;
        this.weightSum = 0;
        this.currentSequence = 0;
        this.segmentStarts.clear();
        this.queryLength = source.getQuery().getTerms().length;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public List<Integer> getSegmentStarts() {
        return this.segmentStarts;
    }

    public float get(String name) {
        try {
            Method getter = this.getClass().getMethod("get" + name.substring(0, 1).toUpperCase() + name.substring(1), new Class[0]);
            return ((Number)getter.invoke((Object)this, new Object[0])).floatValue();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No metric named '" + name + "' is known");
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting metric '" + name + "'", e);
        }
    }

    public int getOutOfOrder() {
        return this.outOfOrder;
    }

    public int getSegments() {
        return this.segments;
    }

    public int getGaps() {
        return this.gaps;
    }

    public int getGapLength() {
        return this.gapLength;
    }

    public int getLongestSequence() {
        return this.longestSequence;
    }

    public int getHead() {
        return this.head;
    }

    public int getTail() {
        return this.tail;
    }

    public int getMatches() {
        return this.matches;
    }

    public int getPairs() {
        return this.pairs;
    }

    public float getAbsoluteProximity() {
        if (this.pairs < 1) {
            return 0.1f;
        }
        return this.proximity / (float)this.pairs;
    }

    public float getUnweightedProximity() {
        if (this.pairs < 1) {
            return 1.0f;
        }
        return this.unweightedProximity / (float)this.pairs;
    }

    public float getSegmentDistance() {
        return this.segmentDistance;
    }

    public float getWeight() {
        return this.weight;
    }

    public float getSignificance() {
        return this.significance;
    }

    public float getOccurrence() {
        return this.occurrence;
    }

    public float getAbsoluteOccurrence() {
        return this.absoluteOccurrence;
    }

    public float getWeightedOccurrence() {
        return this.weightedOccurrence;
    }

    public float getWeightedAbsoluteOccurrence() {
        return this.weightedAbsoluteOccurrence;
    }

    public float getSignificantOccurrence() {
        return this.significantOccurrence;
    }

    public float getExactness() {
        if (this.matches == 0) {
            return 0.0f;
        }
        return this.weightedExactnessSum / (float)this.weightSum;
    }

    public float getQueryCompleteness() {
        return (float)this.matches / (float)this.source.getQuery().getTerms().length;
    }

    public float getFieldCompleteness() {
        return (float)this.matches / (float)this.source.getField().terms().size();
    }

    public float getCompleteness() {
        float fieldCompletenessImportance = this.source.getParameters().getFieldCompletenessImportance();
        return this.getQueryCompleteness() * (1.0f - fieldCompletenessImportance) + fieldCompletenessImportance * this.getFieldCompleteness();
    }

    public float getOrderness() {
        if (this.pairs == 0) {
            return 1.0f;
        }
        return 1.0f - (float)this.outOfOrder / (float)this.pairs;
    }

    public float getRelatedness() {
        if (this.matches == 0) {
            return 0.0f;
        }
        if (this.matches == 1) {
            return 1.0f;
        }
        return 1.0f - (float)(this.segments - 1) / (float)(this.matches - 1);
    }

    public float getLongestSequenceRatio() {
        if (this.matches == 0) {
            return 0.0f;
        }
        return (float)this.longestSequence / (float)this.matches;
    }

    public float getSegmentProximity() {
        if (this.matches == 0) {
            return 0.0f;
        }
        return 1.0f - this.segmentDistance / (float)this.source.getField().terms().size();
    }

    public float getProximity() {
        float totalConnectedness = 0.0f;
        for (int i = 1; i < this.queryLength; ++i) {
            totalConnectedness = (float)((double)totalConnectedness + Math.max(0.1, (double)this.source.getQuery().getTerms()[i].getConnectedness()));
        }
        float averageConnectedness = 0.1f;
        if (this.queryLength > 1) {
            averageConnectedness = totalConnectedness / (float)(this.queryLength - 1);
        }
        return this.getAbsoluteProximity() / averageConnectedness;
    }

    public float getImportance() {
        return (this.getSignificance() + this.getWeight()) / 2.0f;
    }

    public float getEarliness() {
        if (this.matches == 0) {
            return 0.0f;
        }
        if (this.source.getField().terms().size() == 1) {
            return 1.0f;
        }
        return 1.0f - (float)this.head / (float)(Math.max(6, this.source.getField().terms().size()) - 1);
    }

    public float getMatch() {
        float proximityCompletenessImportance = this.source.getParameters().getProximityCompletenessImportance();
        float earlinessImportance = this.source.getParameters().getEarlinessImportance();
        float relatednessImportance = this.source.getParameters().getRelatednessImportance();
        float segmentProximityImportance = this.source.getParameters().getSegmentProximityImportance();
        float occurrenceImportance = this.source.getParameters().getOccurrenceImportance();
        float scaledRelatedness = 1.0f - relatednessImportance + relatednessImportance * this.getRelatedness();
        return (proximityCompletenessImportance * scaledRelatedness * this.getProximity() * this.getExactness() * this.getCompleteness() * this.getCompleteness() + earlinessImportance * this.getEarliness() + segmentProximityImportance * this.getSegmentProximity() + occurrenceImportance * this.getOccurrence()) / (proximityCompletenessImportance + earlinessImportance + segmentProximityImportance + occurrenceImportance);
    }

    float getSegmentationScore() {
        if (this.segments == 0) {
            return 0.0f;
        }
        return this.getAbsoluteProximity() * this.getExactness() / (float)(this.segments * this.segments);
    }

    void onMatch(int i, int j) {
        if (this.matches >= this.source.getField().terms().size()) {
            return;
        }
        ++this.matches;
        this.weight += (float)this.source.getQuery().getTerms()[i].getWeight() / (float)this.source.getQuery().getTotalTermWeight();
        this.significance += this.source.getQuery().getTerms()[i].getSignificance() / this.source.getQuery().getTotalSignificance();
        int queryTermWeight = this.source.getQuery().getTerms()[i].getWeight();
        this.weightedExactnessSum += (float)queryTermWeight * this.source.getQuery().getTerms()[i].getExactness() * this.source.getField().terms().get(j).exactness();
        this.weightSum += queryTermWeight;
    }

    void onSequenceStart(int j) {
        if (this.head == -1 || j < this.head) {
            this.head = j;
        }
        this.currentSequence = 1;
    }

    void onSequenceEnd(int j) {
        int sequenceTail = this.source.getField().terms().size() - j - 1;
        if (this.tail == -1 || sequenceTail < this.tail) {
            this.tail = sequenceTail;
        }
        if (this.currentSequence > this.longestSequence) {
            this.longestSequence = this.currentSequence;
        }
        this.currentSequence = 0;
    }

    void setOccurrence(float occurrence) {
        this.occurrence = occurrence;
    }

    void setWeightedOccurrence(float weightedOccurrence) {
        this.weightedOccurrence = weightedOccurrence;
    }

    void setAbsoluteOccurrence(float absoluteOccurrence) {
        this.absoluteOccurrence = absoluteOccurrence;
    }

    void setWeightedAbsoluteOccurrence(float weightedAbsoluteOccurrence) {
        this.weightedAbsoluteOccurrence = weightedAbsoluteOccurrence;
    }

    void setSignificantOccurrence(float significantOccurrence) {
        this.significantOccurrence = significantOccurrence;
    }

    void onComplete() {
        if (this.segmentStarts.size() <= 1) {
            this.segmentDistance = 0.0f;
        } else {
            Collections.sort(this.segmentStarts);
            for (int i = 1; i < this.segmentStarts.size(); ++i) {
                this.segmentDistance += (float)(this.segmentStarts.get(i) - this.segmentStarts.get(i - 1) + 1);
            }
        }
        if (this.head == -1) {
            this.head = 0;
        }
        if (this.tail == -1) {
            this.tail = 0;
        }
    }

    void onPair(int i, int j, int previousJ) {
        int distance = j - previousJ - 1;
        if (distance < 0) {
            ++distance;
        }
        if (Math.abs(distance) > this.source.getParameters().getProximityLimit()) {
            return;
        }
        float pairProximity = this.source.getParameters().getProximity(distance + this.source.getParameters().getProximityLimit());
        this.unweightedProximity += pairProximity;
        float connectedness = this.source.getQuery().getTerms()[i].getConnectedness();
        this.proximity = (float)((double)this.proximity + Math.pow(pairProximity, (double)connectedness / 0.1) * Math.max(0.1, (double)connectedness));
        ++this.pairs;
    }

    void onInSequence(int i, int j, int previousJ) {
        ++this.currentSequence;
    }

    void onInSegmentGap(int i, int j, int previousJ) {
        ++this.gaps;
        if (j > previousJ) {
            this.gapLength += Math.abs(j - previousJ) - 1;
        } else {
            ++this.outOfOrder;
            this.gapLength += Math.abs(j - previousJ);
        }
    }

    void onNewSegment(int i, int j, int previousJ) {
        ++this.segments;
        this.segmentStarts.add(j);
    }

    public FieldMatchMetrics clone() {
        try {
            FieldMatchMetrics clone = (FieldMatchMetrics)super.clone();
            clone.segmentStarts = new ArrayList<Integer>(this.segmentStarts);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error", e);
        }
    }

    public String toString() {
        return "Metrics: [match: " + this.getMatch() + "]";
    }

    public String toStringDump() {
        try {
            StringBuilder b = new StringBuilder();
            for (Method m : this.getClass().getDeclaredMethods()) {
                if (!m.getName().startsWith("get") || m.getReturnType() != Integer.TYPE && m.getReturnType() != Float.TYPE || m.getParameterTypes().length != 0) continue;
                Object value = m.invoke((Object)this, new Object[0]);
                b.append(m.getName().substring(3, 4).toLowerCase() + m.getName().substring(4) + ": " + value + "\n");
            }
            return b.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Programming error", e);
        }
    }

    public Trace trace() {
        return this.trace;
    }
}

