/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml;

import com.google.common.collect.ImmutableMap;
import com.yahoo.collections.Pair;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class ImportedModel {
    private static final String defaultSignatureName = "default";
    private static final Pattern nameRegexp = Pattern.compile("[A-Za-z0-9_]*");
    private final String name;
    private final String source;
    private final Map<String, Signature> signatures = new HashMap<String, Signature>();
    private final Map<String, TensorType> inputs = new HashMap<String, TensorType>();
    private final Map<String, Tensor> smallConstants = new HashMap<String, Tensor>();
    private final Map<String, Tensor> largeConstants = new HashMap<String, Tensor>();
    private final Map<String, RankingExpression> expressions = new HashMap<String, RankingExpression>();
    private final Map<String, RankingExpression> functions = new HashMap<String, RankingExpression>();

    public ImportedModel(String name, String source) {
        if (!nameRegexp.matcher(name).matches()) {
            throw new IllegalArgumentException("An imported model name can only contain [A-Za-z0-9_], but is '" + name + "'");
        }
        this.name = name;
        this.source = source;
    }

    public String name() {
        return this.name;
    }

    public String source() {
        return this.source;
    }

    public Map<String, TensorType> inputs() {
        return Collections.unmodifiableMap(this.inputs);
    }

    public Map<String, Tensor> smallConstants() {
        return Collections.unmodifiableMap(this.smallConstants);
    }

    public Map<String, Tensor> largeConstants() {
        return Collections.unmodifiableMap(this.largeConstants);
    }

    public Map<String, RankingExpression> expressions() {
        return Collections.unmodifiableMap(this.expressions);
    }

    public Map<String, RankingExpression> functions() {
        return Collections.unmodifiableMap(this.functions);
    }

    public Map<String, Signature> signatures() {
        return Collections.unmodifiableMap(this.signatures);
    }

    Signature signature(String name) {
        return this.signatures.computeIfAbsent(name, x$0 -> new Signature((String)x$0));
    }

    Signature defaultSignature() {
        return this.signature(defaultSignatureName);
    }

    void input(String name, TensorType argumentType) {
        this.inputs.put(name, argumentType);
    }

    void smallConstant(String name, Tensor constant) {
        this.smallConstants.put(name, constant);
    }

    void largeConstant(String name, Tensor constant) {
        this.largeConstants.put(name, constant);
    }

    void expression(String name, RankingExpression expression) {
        this.expressions.put(name, expression);
    }

    void function(String name, RankingExpression expression) {
        this.functions.put(name, expression);
    }

    public List<Pair<String, ExpressionFunction>> outputExpressions() {
        ArrayList<Pair<String, ExpressionFunction>> expressions = new ArrayList<Pair<String, ExpressionFunction>>();
        for (Map.Entry<String, Signature> entry : this.signatures().entrySet()) {
            for (Map.Entry<String, String> outputEntry : entry.getValue().outputs().entrySet()) {
                expressions.add((Pair<String, ExpressionFunction>)new Pair((Object)(entry.getKey() + "." + outputEntry.getKey()), (Object)entry.getValue().outputExpression(outputEntry.getKey()).withName(entry.getKey() + "." + outputEntry.getKey())));
            }
            if (!entry.getValue().outputs().isEmpty()) continue;
            expressions.add((Pair<String, ExpressionFunction>)new Pair((Object)entry.getKey(), (Object)new ExpressionFunction(entry.getKey(), new ArrayList<String>(entry.getValue().inputs().values()), this.expressions().get(entry.getKey()), entry.getValue().inputMap(), Optional.empty())));
        }
        if (this.signatures().isEmpty()) {
            if (this.expressions().size() == 1) {
                Map.Entry<String, RankingExpression> singleEntry = this.expressions.entrySet().iterator().next();
                expressions.add((Pair<String, ExpressionFunction>)new Pair((Object)singleEntry.getKey(), (Object)new ExpressionFunction(singleEntry.getKey(), new ArrayList<String>(this.inputs.keySet()), singleEntry.getValue(), this.inputs, Optional.empty())));
            } else {
                for (Map.Entry<String, Object> entry : this.expressions().entrySet()) {
                    expressions.add((Pair<String, ExpressionFunction>)new Pair((Object)entry.getKey(), (Object)new ExpressionFunction(entry.getKey(), new ArrayList<String>(this.inputs.keySet()), (RankingExpression)entry.getValue(), this.inputs, Optional.empty())));
                }
            }
        }
        return expressions;
    }

    public class Signature {
        private final String name;
        private final Map<String, String> inputs = new LinkedHashMap<String, String>();
        private final Map<String, String> outputs = new LinkedHashMap<String, String>();
        private final Map<String, String> skippedOutputs = new HashMap<String, String>();
        private final List<String> importWarnings = new ArrayList<String>();

        public Signature(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public ImportedModel owner() {
            return ImportedModel.this;
        }

        public Map<String, String> inputs() {
            return Collections.unmodifiableMap(this.inputs);
        }

        public Map<String, TensorType> inputMap() {
            ImmutableMap.Builder inputs = new ImmutableMap.Builder();
            for (Map.Entry<String, String> inputEntry : this.inputs().entrySet()) {
                inputs.put((Object)inputEntry.getValue(), (Object)this.owner().inputs().get(inputEntry.getValue()));
            }
            return inputs.build();
        }

        public TensorType inputArgument(String inputName) {
            return this.owner().inputs().get(this.inputs.get(inputName));
        }

        public Map<String, String> outputs() {
            return Collections.unmodifiableMap(this.outputs);
        }

        public Map<String, String> skippedOutputs() {
            return Collections.unmodifiableMap(this.skippedOutputs);
        }

        public List<String> importWarnings() {
            return Collections.unmodifiableList(this.importWarnings);
        }

        public ExpressionFunction outputExpression(String outputName) {
            return new ExpressionFunction(outputName, new ArrayList<String>(this.inputs.values()), this.owner().expressions().get(this.outputs.get(outputName)), this.inputMap(), Optional.empty());
        }

        public String toString() {
            return "signature '" + this.name + "'";
        }

        void input(String inputName, String argumentName) {
            this.inputs.put(inputName, argumentName);
        }

        void output(String name, String expressionName) {
            this.outputs.put(name, expressionName);
        }

        void skippedOutput(String name, String reason) {
            this.skippedOutputs.put(name, reason);
        }

        void importWarning(String warning) {
            this.importWarnings.add(warning);
        }
    }
}

