/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.ranking.features.fieldmatch;

import com.yahoo.searchlib.ranking.features.fieldmatch.Field;
import com.yahoo.searchlib.ranking.features.fieldmatch.FieldMatchMetrics;
import com.yahoo.searchlib.ranking.features.fieldmatch.FieldMatchMetricsParameters;
import com.yahoo.searchlib.ranking.features.fieldmatch.Query;
import com.yahoo.searchlib.ranking.features.fieldmatch.QueryTerm;
import com.yahoo.searchlib.ranking.features.fieldmatch.SegmentStartPoint;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class FieldMatchMetricsComputer {
    private Query query;
    private Field field;
    private final FieldMatchMetricsParameters parameters;
    private FieldMatchMetrics metrics;
    private List<SegmentStartPoint> segmentStartPoints = new ArrayList<SegmentStartPoint>();
    private boolean collectTrace;
    private int alternativeSegmentationsTried = 0;

    public FieldMatchMetricsComputer() {
        this(FieldMatchMetricsParameters.defaultParameters());
    }

    public FieldMatchMetricsComputer(FieldMatchMetricsParameters parameters) {
        this.parameters = parameters;
    }

    public FieldMatchMetrics compute(String queryString, String fieldString) {
        return this.compute(new Query(queryString), fieldString);
    }

    public FieldMatchMetrics compute(Query query, String fieldString) {
        return this.compute(query, fieldString, false);
    }

    public FieldMatchMetrics compute(Query query, String fieldString, boolean collectTrace) {
        return this.compute(query, new Field(fieldString), collectTrace);
    }

    public FieldMatchMetrics compute(Query query, Field field, boolean collectTrace) {
        this.collectTrace = collectTrace;
        this.query = query;
        this.field = field;
        this.segmentStartPoints.clear();
        for (int i = 0; i <= query.getTerms().length; ++i) {
            this.segmentStartPoints.add(null);
        }
        this.alternativeSegmentationsTried = 0;
        this.metrics = new FieldMatchMetrics(this);
        this.exploreSegments();
        return this.metrics;
    }

    private void exploreSegments() {
        if (this.collectTrace) {
            this.metrics.trace().add("Calculating matches for\n    " + this.query + "\n    " + this.field + "\n");
        }
        SegmentStartPoint segmentStartPoint = new SegmentStartPoint(this.metrics, this);
        this.segmentStartPoints.set(0, segmentStartPoint);
        while (segmentStartPoint != null) {
            this.metrics = segmentStartPoint.getMetrics().clone();
            if (this.collectTrace) {
                this.metrics.trace().add("\nLooking for segment from " + segmentStartPoint + "...\n");
            }
            boolean found = this.findAlternativeSegmentFrom(segmentStartPoint);
            if (this.collectTrace) {
                this.metrics.trace().add(found ? "...found segment: " + this.metrics.getSegmentStarts() + " score: " + this.metrics.getSegmentationScore() : "...no complete and improved segment existed\n");
            }
            if (!found) {
                segmentStartPoint.setOpen(false);
            }
            segmentStartPoint = this.findOpenSegment(segmentStartPoint.getI());
        }
        this.metrics = this.findLastStartPoint().getMetrics();
        this.setOccurrenceCounts(this.metrics);
        this.metrics.onComplete();
        this.metrics.setComplete(true);
    }

    private boolean findAlternativeSegmentFrom(SegmentStartPoint segmentStartPoint) {
        int semanticDistanceExplored = segmentStartPoint.getSemanticDistanceExplored();
        int previousI = -1;
        int previousJ = segmentStartPoint.getPreviousJ();
        boolean hasOpenSequence = false;
        boolean isFirst = true;
        for (int i = segmentStartPoint.getStartI(); i < this.query.getTerms().length; ++i) {
            int semanticDistance = this.findClosestInFieldBySemanticDistance(i, previousJ, semanticDistanceExplored);
            int j = this.semanticDistanceToFieldIndex(semanticDistance, previousJ);
            if (j == -1 && semanticDistanceExplored > 0 && isFirst) {
                return false;
            }
            if (hasOpenSequence && (j == -1 || j != previousJ + 1)) {
                this.metrics.onSequenceEnd(previousJ);
                hasOpenSequence = false;
            }
            if (isFirst) {
                if (j != -1) {
                    this.segmentStart(i, j, isFirst ? -1 : previousJ);
                    segmentStartPoint.exploredTo(j);
                    isFirst = false;
                } else {
                    segmentStartPoint.incrementStartI();
                }
            } else {
                if (Math.abs(j - previousJ) >= this.parameters.getProximityLimit()) {
                    this.segmentEnd(i - 1, previousJ);
                    return true;
                }
                if (j != -1) {
                    this.inSegment(i, j, previousJ, previousI);
                }
            }
            if (j != -1) {
                this.metrics.onMatch(i, j);
            }
            if (j != -1 && !hasOpenSequence) {
                this.metrics.onSequenceStart(j);
                hasOpenSequence = true;
            }
            semanticDistanceExplored = j != -1 ? 1 : 0;
            if (j < 0) continue;
            previousI = i;
            previousJ = j;
        }
        if (hasOpenSequence) {
            this.metrics.onSequenceEnd(previousJ);
        }
        if (!isFirst) {
            this.segmentEnd(this.query.getTerms().length - 1, previousJ);
            return true;
        }
        return false;
    }

    private int findClosestInFieldBySemanticDistance(int i, int previousJ, int startSemanticDistance) {
        String term = this.query.getTerms()[i].getTerm();
        for (int distance = startSemanticDistance; distance < this.field.terms().size(); ++distance) {
            int j = this.semanticDistanceToFieldIndex(distance, previousJ);
            if (!term.equals(this.field.terms().get(j).value())) continue;
            return distance;
        }
        return -1;
    }

    int semanticDistanceToFieldIndex(int semanticDistance, int zeroJ) {
        if (semanticDistance == -1) {
            return -1;
        }
        int firstSegmentLength = Math.min(this.parameters.getProximityLimit(), this.field.terms().size() - zeroJ);
        int secondSegmentLength = Math.min(this.parameters.getProximityLimit(), zeroJ);
        if (semanticDistance < firstSegmentLength) {
            return zeroJ + semanticDistance;
        }
        if (semanticDistance < firstSegmentLength + secondSegmentLength) {
            return zeroJ - semanticDistance - 1 + firstSegmentLength;
        }
        if (semanticDistance < this.field.terms().size() - zeroJ + secondSegmentLength) {
            return zeroJ + semanticDistance - secondSegmentLength;
        }
        return this.field.terms().size() - semanticDistance - 1;
    }

    int fieldIndexToSemanticDistance(int j, int zeroJ) {
        if (j == -1) {
            return -1;
        }
        int firstSegmentLength = Math.min(this.parameters.getProximityLimit(), this.field.terms().size() - zeroJ);
        int secondSegmentLength = Math.min(this.parameters.getProximityLimit(), zeroJ);
        if (j >= zeroJ) {
            if (j - zeroJ < firstSegmentLength) {
                return j - zeroJ;
            }
            return j - zeroJ + secondSegmentLength;
        }
        if (zeroJ - j - 1 < secondSegmentLength) {
            return zeroJ - j + firstSegmentLength - 1;
        }
        return zeroJ - j - 1 + this.field.terms().size() - zeroJ;
    }

    private void inSegment(int i, int j, int previousJ, int previousI) {
        this.metrics.onPair(i, j, previousJ);
        if (j == previousJ + 1 && i == previousI + 1) {
            this.metrics.onInSequence(i, j, previousJ);
        } else {
            this.metrics.onInSegmentGap(i, j, previousJ);
            if (this.collectTrace) {
                this.metrics.trace().add("      in segment gap: " + i + "->" + j + " (" + this.query.getTerms()[i] + ")\n");
            }
        }
    }

    private boolean segmentStart(int i, int j, int previousJ) {
        this.metrics.onNewSegment(i, j, previousJ);
        if (previousJ >= 0) {
            this.metrics.onPair(i, j, previousJ);
        }
        if (this.collectTrace) {
            this.metrics.trace().add("    new segment at:   " + i + "->" + j + " (" + this.query.getTerms()[i] + ")\n");
        }
        return true;
    }

    private void segmentEnd(int i, int j) {
        SegmentStartPoint startOfNext;
        if (this.collectTrace) {
            this.metrics.trace().add("    segment ended at: " + i + "->" + j + " (" + this.query.getTerms()[i] + ")\n");
        }
        if ((startOfNext = this.segmentStartPoints.get(i + 1)) == null) {
            this.segmentStartPoints.set(i + 1, new SegmentStartPoint(i + 1, j, this.metrics, this));
        } else {
            startOfNext.offerHistory(j, this.metrics, this.collectTrace);
        }
    }

    private SegmentStartPoint findOpenSegment(int startI) {
        for (int i = startI; i < this.segmentStartPoints.size(); ++i) {
            SegmentStartPoint startPoint = this.segmentStartPoints.get(i);
            if (startPoint == null || !startPoint.isOpen()) continue;
            if (startPoint.getSemanticDistanceExplored() == 0) {
                return startPoint;
            }
            if (this.alternativeSegmentationsTried >= this.parameters.getMaxAlternativeSegmentations()) continue;
            ++this.alternativeSegmentationsTried;
            return startPoint;
        }
        return null;
    }

    private SegmentStartPoint findLastStartPoint() {
        for (int i = this.segmentStartPoints.size() - 1; i >= 0; --i) {
            SegmentStartPoint startPoint = this.segmentStartPoints.get(i);
            if (startPoint == null) continue;
            return startPoint;
        }
        return null;
    }

    private void setOccurrenceCounts(FieldMatchMetrics metrics) {
        HashSet<QueryTerm> uniqueQueryTerms = new HashSet<QueryTerm>();
        for (QueryTerm queryTerm2 : this.query.getTerms()) {
            uniqueQueryTerms.add(queryTerm2);
        }
        ArrayList<Float> weightedOccurrences = new ArrayList<Float>();
        ArrayList<Float> significantOccurrences = new ArrayList<Float>();
        int divider = Math.min(this.field.terms().size(), this.parameters.getMaxOccurrences() * uniqueQueryTerms.size());
        int maxOccurence = Math.min(this.field.terms().size(), this.parameters.getMaxOccurrences());
        float occurrence = 0.0f;
        float absoluteOccurrence = 0.0f;
        float weightedAbsoluteOccurrence = 0.0f;
        int totalWeight = 0;
        float totalWeightedOccurrences = 0.0f;
        float totalSignificantOccurrences = 0.0f;
        for (QueryTerm queryTerm : uniqueQueryTerms) {
            int termOccurrences = 0;
            for (Field.Term fieldTerm : this.field.terms()) {
                if (fieldTerm.value().equals(queryTerm.getTerm())) {
                    ++termOccurrences;
                }
                if (termOccurrences != this.parameters.getMaxOccurrences()) continue;
                break;
            }
            occurrence += (float)termOccurrences / (float)divider;
            absoluteOccurrence += (float)termOccurrences / (float)(this.parameters.getMaxOccurrences() * uniqueQueryTerms.size());
            weightedAbsoluteOccurrence += (float)termOccurrences * (float)queryTerm.getWeight() / (float)this.parameters.getMaxOccurrences();
            totalWeight += queryTerm.getWeight();
            totalWeightedOccurrences += (float)maxOccurence * (float)queryTerm.getWeight() / (float)divider;
            weightedOccurrences.add(Float.valueOf((float)termOccurrences * (float)queryTerm.getWeight() / (float)divider));
            totalSignificantOccurrences += (float)maxOccurence * queryTerm.getSignificance() / (float)divider;
            significantOccurrences.add(Float.valueOf((float)termOccurrences * queryTerm.getSignificance() / (float)divider));
        }
        float weightedOccurrenceSum = 0.0f;
        Iterator iterator = weightedOccurrences.iterator();
        while (iterator.hasNext()) {
            float weightedOccurence = ((Float)iterator.next()).floatValue();
            weightedOccurrenceSum += weightedOccurence / totalWeightedOccurrences;
        }
        float f = 0.0f;
        Iterator iterator2 = significantOccurrences.iterator();
        while (iterator2.hasNext()) {
            float significantOccurence = ((Float)iterator2.next()).floatValue();
            f += significantOccurence / totalSignificantOccurrences;
        }
        if (totalWeight > 0) {
            weightedAbsoluteOccurrence /= (float)totalWeight;
        }
        metrics.setOccurrence(occurrence);
        metrics.setAbsoluteOccurrence(absoluteOccurrence);
        metrics.setWeightedOccurrence(weightedOccurrenceSum);
        metrics.setWeightedAbsoluteOccurrence(weightedAbsoluteOccurrence);
        metrics.setSignificantOccurrence(f);
    }

    public FieldMatchMetricsParameters getParameters() {
        return this.parameters;
    }

    Query getQuery() {
        return this.query;
    }

    Field getField() {
        return this.field;
    }

    public String toString() {
        return this.query + "\n" + this.field + "\n" + this.metrics + "\n";
    }
}

