/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.ml;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.integration.ml.ImportedModel;
import com.yahoo.searchlib.rankingexpression.integration.ml.ModelImporter;
import com.yahoo.searchlib.rankingexpression.integration.ml.importer.xgboost.XGBoostParser;
import com.yahoo.searchlib.rankingexpression.parser.ParseException;
import java.io.File;
import java.io.IOException;

public class XGBoostImporter
extends ModelImporter {
    @Override
    public boolean canImport(String modelPath) {
        File modelFile = new File(modelPath);
        if (!modelFile.isFile()) {
            return false;
        }
        return modelFile.toString().endsWith(".json");
    }

    @Override
    public ImportedModel importModel(String modelName, String modelPath) {
        try {
            ImportedModel model = new ImportedModel(modelName);
            XGBoostParser parser = new XGBoostParser(modelPath);
            RankingExpression expression = new RankingExpression(parser.toRankingExpression());
            model.expression(modelName, expression);
            return model;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not import XGBoost model from '" + modelPath + "'", e);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse ranking expression resulting from '" + modelPath + "'", e);
        }
    }
}

