/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression;

import com.google.common.collect.ImmutableList;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.text.Utf8;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExpressionFunction {
    private final String name;
    private final ImmutableList<String> arguments;
    private final RankingExpression body;

    public ExpressionFunction(String name, List<String> arguments, RankingExpression body) {
        this.name = name;
        this.arguments = arguments == null ? ImmutableList.of() : ImmutableList.copyOf(arguments);
        this.body = body;
    }

    public String getName() {
        return this.name;
    }

    public List<String> arguments() {
        return this.arguments;
    }

    public RankingExpression getBody() {
        return this.body;
    }

    public ExpressionFunction withBody(RankingExpression body) {
        return new ExpressionFunction(this.name, (List<String>)this.arguments, body);
    }

    public Instance expand(SerializationContext context, List<ExpressionNode> argumentValues, Deque<String> path) {
        HashMap<String, String> argumentBindings = new HashMap<String, String>();
        for (int i = 0; i < this.arguments.size() && i < argumentValues.size(); ++i) {
            argumentBindings.put((String)this.arguments.get(i), argumentValues.get(i).toString(new StringBuilder(), context, path, null).toString());
        }
        return new Instance(this.toSymbol(argumentBindings), this.body.getRoot().toString(new StringBuilder(), (SerializationContext)context.withBindings(argumentBindings), path, null).toString());
    }

    private String toSymbol(Map<String, String> argumentBindings) {
        if (argumentBindings.isEmpty()) {
            return this.name;
        }
        StringBuilder ret = new StringBuilder();
        ret.append(this.name).append("@");
        for (Map.Entry<String, String> argumentBinding : argumentBindings.entrySet()) {
            ret.append(Long.toHexString(ExpressionFunction.symbolCode(argumentBinding.getKey() + "=" + argumentBinding.getValue())));
            ret.append(".");
        }
        if (ret.toString().endsWith(".")) {
            ret.setLength(ret.length() - 1);
        }
        return ret.toString();
    }

    private static long symbolCode(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] buf = md.digest(Utf8.toBytes((String)str));
            if (buf.length >= 8) {
                long ret = 0L;
                for (int i = 0; i < 8; ++i) {
                    ret = (ret << 8) + (long)(buf[i] & 0xFF);
                }
                return ret;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("java must always support SHA-1 message digest format", e);
        }
        return str.hashCode();
    }

    public String toString() {
        return "function '" + this.name + "'";
    }

    public class Instance {
        private final String name;
        private final String expressionString;

        public Instance(String name, String expressionString) {
            this.name = name;
            this.expressionString = expressionString;
        }

        public String getName() {
            return this.name;
        }

        public String getExpressionString() {
            return this.expressionString;
        }
    }
}

