/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.ExpressionFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SerializationContext {
    private final ImmutableMap<String, ExpressionFunction> functions;
    private final Map<String, String> serializedFunctions;
    public final Map<String, String> bindings = new HashMap<String, String>();

    public SerializationContext() {
        this(Collections.emptyList());
    }

    public SerializationContext(Collection<ExpressionFunction> functions) {
        this(functions, Collections.emptyMap(), new LinkedHashMap<String, String>());
    }

    public SerializationContext(Map<String, ExpressionFunction> functions) {
        this(functions.values());
    }

    public SerializationContext(List<ExpressionFunction> functions, Map<String, String> bindings) {
        this(functions, bindings, new LinkedHashMap<String, String>());
    }

    public SerializationContext(Collection<ExpressionFunction> functions, Map<String, String> bindings, Map<String, String> serializedFunctions) {
        this(SerializationContext.toMap(functions), bindings, serializedFunctions);
    }

    private static ImmutableMap<String, ExpressionFunction> toMap(Collection<ExpressionFunction> list) {
        ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
        for (ExpressionFunction function : list) {
            mapBuilder.put((Object)function.getName(), (Object)function);
        }
        return mapBuilder.build();
    }

    public SerializationContext(ImmutableMap<String, ExpressionFunction> functions, Map<String, String> bindings, Map<String, String> serializedFunctions) {
        this.functions = functions;
        this.serializedFunctions = serializedFunctions;
        if (bindings != null) {
            this.bindings.putAll(bindings);
        }
    }

    public ExpressionFunction getFunction(String name) {
        return (ExpressionFunction)this.functions.get((Object)name);
    }

    public void addFunctionSerialization(String name, String expressionString) {
        this.serializedFunctions.put(name, expressionString);
    }

    public String getFunctionSerialization(String name) {
        return this.serializedFunctions.get(name);
    }

    public String getBinding(String name) {
        return this.bindings.get(name);
    }

    public SerializationContext createBinding(Map<String, String> arguments) {
        return new SerializationContext(this.functions, arguments, this.serializedFunctions);
    }

    public Map<String, String> serializedFunctions() {
        return this.serializedFunctions;
    }
}

