/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.AbstractArrayContext;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;

public class DoubleOnlyArrayContext
extends AbstractArrayContext {
    public DoubleOnlyArrayContext(RankingExpression expression) {
        this(expression, false);
    }

    public DoubleOnlyArrayContext(RankingExpression expression, boolean ignoreUnknownValues) {
        super(expression, ignoreUnknownValues);
    }

    @Override
    public final void put(String name, Value value) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            if (this.ignoreUnknownValues()) {
                return;
            }
            throw new IllegalArgumentException("Value '" + name + "' is not known to " + this);
        }
        this.put((int)index, value);
    }

    public final void put(int index, double value) {
        this.doubleValues()[index] = value;
    }

    public final void put(int index, Value value) {
        try {
            this.put(index, value.asDouble());
        }
        catch (UnsupportedOperationException e) {
            throw new IllegalArgumentException("This context only supports doubles, not " + value);
        }
    }

    @Override
    public Value get(String name) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            return DoubleValue.zero;
        }
        return new DoubleValue(this.getDouble(index));
    }

    @Override
    public final Value get(int index) {
        return new DoubleValue(this.getDouble(index));
    }

    @Override
    public DoubleOnlyArrayContext clone() {
        return (DoubleOnlyArrayContext)super.clone();
    }
}

