/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser.common;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.parser.grouping.Token;
import ai.vespa.schemals.parser.grouping.ast.BaseNode;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.tree.Node;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class IdentifyIllegalArgumentNodes
extends Identifier<Node> {
    public IdentifyIllegalArgumentNodes(ParseContext context) {
        super(context);
    }

    @Override
    public void identify(Node node, List<Diagnostic> diagnostics) {
        if (node.getLanguageType() == Node.LanguageType.SCHEMA && node.getSchemaNode().getOriginalSchemaNode() instanceof ai.vespa.schemals.parser.Token) {
            ai.vespa.schemals.parser.Token nodeAsToken = (ai.vespa.schemals.parser.Token)node.getSchemaNode().getOriginalSchemaNode();
            this.maybeAddToDiagnostics(diagnostics, node, nodeAsToken.getIllegalArgumentException());
        }
        if (node.getLanguageType() == Node.LanguageType.GROUPING) {
            if (node.getYQLNode().getOriginalGroupingNode() instanceof Token) {
                Token nodeAsGroupingToken = (Token)node.getYQLNode().getOriginalGroupingNode();
                this.maybeAddToDiagnostics(diagnostics, node, nodeAsGroupingToken.getIllegalArgumentException());
            }
            if (node.getYQLNode().getOriginalGroupingNode() instanceof BaseNode) {
                BaseNode nodeAsBaseNode = (BaseNode)node.getYQLNode().getOriginalGroupingNode();
                this.maybeAddToDiagnostics(diagnostics, node, nodeAsBaseNode.getIllegalArgumentException());
            }
        }
    }

    private void maybeAddToDiagnostics(List<Diagnostic> diagnostics, Node node, Exception ex) {
        if (ex == null) {
            return;
        }
        diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage(ex.getMessage()).setSeverity(DiagnosticSeverity.Error).build());
    }
}

