Creates a `tensor<type>` with one mapped dimension from the given `array<struct>` attribute. Keys are taken from the struct field *key* and values from the struct field *value* . The resulting tensor will have one mapped dimension named after the *key* field. The *type* parameter is required and must be `float` or `double`. The function takes exactly four arguments.

Example: Given an `array<struct>` attribute `items` with fields `name` (string) and `price` (float):

```
tensorFromStructs(attribute(items), name, price, float)
```

```
tensor<float>(name{}):{ {name:apple}:1.5, {name:banana}:0.75, {name:cherry}:2.25 }
```

Example: Integer keys and float values:

```
tensorFromStructs(attribute(ids), id, score, double)
```

```
tensor(id{}):{ {id:100}:10.5, {id:200}:20.75, {id:300}:30.25 }
```

*Details:* Empty or missing arrays yield an empty tensor of the requested type. The first argument must be an `attribute(...)` source.

See *tensorFromWeightedSet* for performance notes.

Default: empty tensor