/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.parser.schema;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.FLOAT_KEYWORD;
import ai.vespa.schemals.parser.ast.LONG_KEYWORD;
import ai.vespa.schemals.parser.ast.annotationBody;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.inputElm;
import ai.vespa.schemals.parser.ast.valueType;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.schema.parser.ParsedType;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class IdentifyType
extends Identifier<SchemaNode> {
    public IdentifyType(ParseContext context) {
        super(context);
    }

    @Override
    public void identify(SchemaNode node, List<Diagnostic> diagnostics) {
        ParsedType keyParsedType;
        Node keyTypeNode;
        if (node.isASTInstance(inputElm.class)) {
            this.identifyInputType(node, diagnostics);
            return;
        }
        if (!node.isASTInstance(dataType.class)) {
            return;
        }
        dataType originalNode = (dataType)node.getOriginalSchemaNode();
        ParsedType parsedType = originalNode.getParsedType();
        if (originalNode.isArrayOldStyle) {
            String nodeText = node.get(0).getText();
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Data type syntax '" + nodeText + "[]' is deprecated, use 'array<" + nodeText + ">' instead.").setSeverity(DiagnosticSeverity.Warning).setCode(SchemaDiagnostic.DiagnosticCode.DEPRECATED_ARRAY_SYNTAX).build());
        }
        if (parsedType == null) {
            return;
        }
        if (parsedType.getVariant() == ParsedType.Variant.ANN_REFERENCE && !IdentifyType.isInsideAnnotationBody(node)) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("annotationreference should only be used inside an annotation").setSeverity(DiagnosticSeverity.Error).setCode(SchemaDiagnostic.DiagnosticCode.ANNOTATION_REFERENCE_OUTSIDE_ANNOTATION).build());
        }
        if (parsedType.getVariant() == ParsedType.Variant.MAP && (keyTypeNode = node.get(0).get(2)) != null && keyTypeNode.isASTInstance(dataType.class) && (keyParsedType = ((dataType)keyTypeNode.getSchemaNode().getOriginalSchemaNode()).getParsedType()).getVariant() != ParsedType.Variant.BUILTIN) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(keyTypeNode.getRange()).setMessage("Map key type must be a primitive type").setSeverity(DiagnosticSeverity.Error).build());
        }
        if (parsedType.getVariant() != ParsedType.Variant.UNKNOWN) {
            return;
        }
        Optional<Symbol> scope = CSTUtils.findScope(node);
        if (scope.isPresent()) {
            node.setSymbol(Symbol.SymbolType.TYPE_UNKNOWN, this.context.fileURI(), scope.get());
        } else {
            node.setSymbol(Symbol.SymbolType.TYPE_UNKNOWN, this.context.fileURI());
        }
        this.context.addUnresolvedTypeNode(node);
    }

    private static boolean isInsideAnnotationBody(SchemaNode node) {
        for (Node currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            if (!((Node)currentNode).isASTInstance(annotationBody.class)) continue;
            return true;
        }
        return false;
    }

    private void identifyInputType(SchemaNode node, List<Diagnostic> diagnostics) {
        if (!node.isASTInstance(inputElm.class) || node.size() == 0) {
            return;
        }
        Node valueTypeNode = null;
        for (Node child : node) {
            if (!child.isASTInstance(valueType.class)) continue;
            valueTypeNode = child.getSchemaNode();
            break;
        }
        if (valueTypeNode == null) {
            return;
        }
        Node typeToken = valueTypeNode.findFirstLeaf();
        String identifierName = node.get(0).getText();
        String warningMessage = null;
        if (typeToken.isASTInstance(LONG_KEYWORD.class)) {
            warningMessage = "Input " + identifierName + ": 'long' is not possible, treated as 'double'";
        }
        if (typeToken.isASTInstance(FLOAT_KEYWORD.class)) {
            warningMessage = "Input " + identifierName + ": 'float' is not possible, treated as 'double'";
        }
        if (warningMessage != null) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(valueTypeNode.getRange()).setMessage(warningMessage).setSeverity(DiagnosticSeverity.Warning).build());
        }
    }
}

