/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.parser.grouping.GroupingParser;
import ai.vespa.schemals.parser.grouping.Node;
import ai.vespa.schemals.parser.grouping.ParseException;
import ai.vespa.schemals.parser.grouping.Token;
import ai.vespa.schemals.schemadocument.YQLDocument;
import ai.vespa.schemals.tree.YQLNode;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Position;

class VespaGroupingParser {
    VespaGroupingParser() {
    }

    static YQLDocument.YQLPartParseResult parseVespaGrouping(String input, ClientLogger logger, Position offset, int charOffset) {
        String charSequence = input.toLowerCase();
        GroupingParser parser = new GroupingParser(charSequence);
        try {
            parser.request();
        }
        catch (ParseException exception) {
            logger.error(exception.getMessage());
        }
        Node node = parser.rootNode();
        YQLNode CST = new YQLNode(node, offset, charOffset);
        int charsRead = parser.getToken(0).getEndOffset();
        return new YQLDocument.YQLPartParseResult(List.of(), Optional.of(CST), charsRead -= VespaGroupingParser.removeEOFToken(CST, logger));
    }

    private static int removeEOFToken(YQLNode CST, ClientLogger logger) {
        if (CST.size() == 0) {
            return 0;
        }
        YQLNode child = CST.get(CST.size() - 1).getYQLNode();
        if (child.getASTClass() != Token.class) {
            return 0;
        }
        Node origNode = child.getOriginalGroupingNode();
        if (origNode.getType() != Token.TokenType.EOF) {
            return 0;
        }
        CST.removeChild(CST.size() - 1);
        return origNode.getLength();
    }
}

