/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.yqlplus.semantictokens;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.context.EventDocumentContext;
import ai.vespa.schemals.lsp.common.semantictokens.CommonSemanticTokens;
import ai.vespa.schemals.lsp.common.semantictokens.SemanticTokenMarker;
import ai.vespa.schemals.lsp.yqlplus.semantictokens.VespaGroupingSemanticToken;
import ai.vespa.schemals.lsp.yqlplus.semantictokens.YQLPlusSemanticTokenConfig;
import ai.vespa.schemals.parser.yqlplus.ast.pipeline_step;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.YQLNode;
import com.yahoo.collections.Pair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.SemanticTokens;

public class YQLPlusSemanticTokens {
    public static void init() {
        CommonSemanticTokens.addTokenType("keyword");
        CommonSemanticTokens.addTokenTypes(new ArrayList<String>(YQLPlusSemanticTokenConfig.tokensMap.values()));
        CommonSemanticTokens.addTokenTypes(new ArrayList<String>(VespaGroupingSemanticToken.tokensMap.values()));
    }

    private static List<SemanticTokenMarker> parseYQLLanguage(YQLNode node, ClientLogger logger) {
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>();
        Class<?> nodeClass = node.getASTClass();
        String tokenString = YQLPlusSemanticTokenConfig.tokensMap.get(nodeClass);
        if (tokenString != null) {
            ret.add(new SemanticTokenMarker(tokenString, (Node)node));
        } else if (YQLPlusSemanticTokenConfig.keywordTokens.contains(nodeClass)) {
            ret.add(new SemanticTokenMarker("keyword", (Node)node));
        } else if (node.getASTClass() != pipeline_step.class) {
            for (Node child : node) {
                ret.addAll(YQLPlusSemanticTokens.traverseCST(child.getYQLNode(), logger));
            }
        }
        return ret;
    }

    private static List<SemanticTokenMarker> traverseGroupingLanguage(YQLNode node, ClientLogger logger) {
        Class<?> parentClass;
        Pair key;
        Class<?> nodeClass = node.getASTClass();
        String tokenString = VespaGroupingSemanticToken.tokensMap.get(nodeClass);
        if (tokenString != null) {
            return SemanticTokenMarker.GetAsList(tokenString, node);
        }
        Node parent = node.getParent();
        if (parent != null && (tokenString = VespaGroupingSemanticToken.tokensMapWithParent.get(key = new Pair(nodeClass, parentClass = parent.getASTClass()))) != null) {
            return SemanticTokenMarker.GetAsList(tokenString, node);
        }
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>();
        for (Node child : node) {
            ret.addAll(YQLPlusSemanticTokens.traverseCST(child.getYQLNode(), logger));
        }
        return ret;
    }

    private static List<SemanticTokenMarker> traverseCST(YQLNode node, ClientLogger logger) {
        if (node.getIsDirty()) {
            return new ArrayList<SemanticTokenMarker>();
        }
        if (node.getLanguageType() == Node.LanguageType.YQLPlus) {
            return YQLPlusSemanticTokens.parseYQLLanguage(node, logger);
        }
        if (node.getLanguageType() == Node.LanguageType.GROUPING) {
            return YQLPlusSemanticTokens.traverseGroupingLanguage(node, logger);
        }
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>();
        for (Node child : node) {
            ret.addAll(YQLPlusSemanticTokens.traverseCST(child.getYQLNode(), logger));
        }
        return ret;
    }

    public static SemanticTokens getSemanticTokens(EventDocumentContext context) {
        if (context.document == null) {
            return new SemanticTokens(new ArrayList());
        }
        YQLNode node = context.document.getRootYQLNode();
        if (node == null) {
            return new SemanticTokens(new ArrayList());
        }
        List<SemanticTokenMarker> markers = YQLPlusSemanticTokens.traverseCST(node, context.logger);
        List<Integer> compactMarkers = SemanticTokenMarker.concatCompactForm(markers);
        return new SemanticTokens(compactMarkers);
    }
}

