/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.yqlplus.completion.provider;

import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.common.completion.CompletionProvider;
import ai.vespa.schemals.lsp.common.completion.CompletionUtils;
import ai.vespa.schemals.parser.yqlplus.ast.FROM;
import ai.vespa.schemals.parser.yqlplus.ast.SOURCES;
import ai.vespa.schemals.parser.yqlplus.ast.limit_fun;
import ai.vespa.schemals.parser.yqlplus.ast.offset_fun;
import ai.vespa.schemals.parser.yqlplus.ast.orderby_fun;
import ai.vespa.schemals.parser.yqlplus.ast.query_statement;
import ai.vespa.schemals.parser.yqlplus.ast.select_source;
import ai.vespa.schemals.parser.yqlplus.ast.select_source_sources;
import ai.vespa.schemals.parser.yqlplus.ast.select_statement;
import ai.vespa.schemals.parser.yqlplus.ast.timeout_fun;
import ai.vespa.schemals.parser.yqlplus.ast.where_fun;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.YQLNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public class RootCompletion
implements CompletionProvider {
    private final List<StatementPair> statementOrder = new ArrayList<StatementPair>(){
        {
            this.add(new StatementPair(select_statement.class, "select"));
            this.add(new StatementPair(select_source.class, "from"));
            this.add(new StatementPair(where_fun.class, "where"));
            this.add(new StatementPair(orderby_fun.class, "order by"));
            this.add(new StatementPair(limit_fun.class, "limit"));
            this.add(new StatementPair(offset_fun.class, "offset"));
            this.add(new StatementPair(timeout_fun.class, "timeout"));
        }
    };

    private int statementOrderListContains(Class<?> cls) {
        for (int i = 0; i < this.statementOrder.size(); ++i) {
            if (this.statementOrder.get((int)i).parentClass != cls) continue;
            return i;
        }
        return -1;
    }

    private List<String> getLastestStatement(YQLNode node) {
        YQLNode iterator = node;
        YQLNode lastIterator = node;
        while (!iterator.isASTInstance(query_statement.class) && iterator != null) {
            int hitIndex = this.statementOrderListContains(iterator.getASTClass());
            if (hitIndex != -1 && lastIterator != iterator.get(0)) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int i = hitIndex + 1; i < this.statementOrder.size(); ++i) {
                    ret.add(this.statementOrder.get(i).statement());
                }
                return ret;
            }
            lastIterator = iterator;
            if (iterator.getParent() == null) {
                iterator = null;
                continue;
            }
            iterator = iterator.getParent().getYQLNode();
        }
        return List.of();
    }

    private boolean isInsideSelectSources(Node node) {
        while (node != null) {
            if (node.isASTInstance(SOURCES.class)) {
                return true;
            }
            if (node.isASTInstance(select_source_sources.class)) {
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        Node last;
        ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
        Position searchPos = context.startOfWord();
        if (searchPos == null) {
            searchPos = context.position;
        }
        if ((last = CSTUtils.getLastCleanNode(context.document.getRootYQLNode(), searchPos)) == null) {
            return ret;
        }
        if (!last.isYQLNode()) {
            throw new IllegalArgumentException("Unexpected node type, expected a YQLNode");
        }
        if (last.getLanguageType() == Node.LanguageType.GROUPING) {
            return ret;
        }
        if (last.isASTInstance(FROM.class) || this.isInsideSelectSources(last)) {
            if (last.isASTInstance(FROM.class)) {
                ret.add(CompletionUtils.constructSnippet("sources", "sources ${1:*}"));
            }
            if (last.isASTInstance(SOURCES.class)) {
                ret.add(CompletionUtils.constructBasic("*"));
            }
            context.schemaIndex.listSymbolsInScope(null, Symbol.SymbolType.DOCUMENT).stream().forEach(symbol -> {
                String name = symbol.getShortIdentifier();
                ret.add(CompletionUtils.constructBasic(name));
            });
            return ret;
        }
        YQLNode node = last.getYQLNode();
        if (node.getLanguageType() == Node.LanguageType.CUSTOM && node.getText() == "|") {
            return ret;
        }
        if (node.isASTInstance(YQLNode.class)) {
            ret.add(CompletionUtils.constructSnippet("select", "select ${1:*} from $2 where $0"));
            return ret;
        }
        List<String> completionStrings = this.getLastestStatement(node);
        for (String completionStr : completionStrings) {
            ret.add(CompletionUtils.constructSnippet(completionStr, completionStr + " $0"));
        }
        return ret;
    }

    private record StatementPair(Class<?> parentClass, String statement) {
    }
}

