/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command.commandtypes;

import ai.vespa.schemals.context.EventExecuteCommandContext;
import ai.vespa.schemals.lsp.common.command.CommandRegistry;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.ExecuteCommandParams;

public class CommandList
implements SchemaCommand {
    List<SchemaCommand> commandsToExecute = new ArrayList<SchemaCommand>();

    @Override
    public int getArity() {
        return -1;
    }

    @Override
    public boolean setArguments(List<Object> arguments2) {
        this.commandsToExecute.clear();
        for (Object object : arguments2) {
            if (!(object instanceof JsonObject)) {
                return false;
            }
            JsonObject jsonObject = (JsonObject)object;
            if (!jsonObject.has("command") || !jsonObject.get("command").isJsonPrimitive()) {
                return false;
            }
            if (!jsonObject.has("arguments") || !jsonObject.get("arguments").isJsonArray()) {
                return false;
            }
            ExecuteCommandParams params = new ExecuteCommandParams(jsonObject.get("command").getAsString(), new ArrayList(((JsonArray)jsonObject.get("arguments")).asList()));
            Optional<SchemaCommand> command = CommandRegistry.getCommand(params);
            if (command.isEmpty()) {
                return false;
            }
            this.commandsToExecute.add(command.get());
        }
        return true;
    }

    @Override
    public Object execute(EventExecuteCommandContext context) {
        for (SchemaCommand cmd : this.commandsToExecute) {
            cmd.execute(context);
        }
        return null;
    }
}

