/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.documentation;

import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolver;
import com.vladsch.flexmark.html2md.converter.HtmlLinkResolverFactory;
import com.vladsch.flexmark.html2md.converter.HtmlNodeConverterContext;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Node;

public abstract class ContentFetcher {
    protected static final String URL_PREFIX = "https://docs.vespa.ai/";
    String fileUrl;

    ContentFetcher(String relativeFileUrl) {
        this.fileUrl = relativeFileUrl;
    }

    abstract Map<String, String> getMarkdownContent() throws IOException;

    FlexmarkHtmlConverter getHtmlParser() {
        MutableDataSet options = new MutableDataSet().set(FlexmarkHtmlConverter.OUTPUT_ATTRIBUTES_ID, (Object)false).set(FlexmarkHtmlConverter.SETEXT_HEADINGS, (Object)false).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(Parser.EXTENSIONS, Collections.singletonList(new HtmlConverterTextExtension(this.fileUrl)));
        return FlexmarkHtmlConverter.builder((DataHolder)options).build();
    }

    static class HtmlConverterTextExtension
    implements FlexmarkHtmlConverter.HtmlConverterExtension {
        private String fileUrl;

        public HtmlConverterTextExtension(String fileUrl) {
            this.fileUrl = fileUrl;
        }

        public void rendererOptions(@NotNull MutableDataHolder options) {
        }

        public void extend(// Could not load outer class - annotation placement on inner may be incorrect
        @NotNull FlexmarkHtmlConverter.Builder builder) {
            builder.linkResolverFactory((HtmlLinkResolverFactory)new CustomLinkResolver.Factory(this.fileUrl));
        }
    }

    static class CustomLinkResolver
    implements HtmlLinkResolver {
        String fileUrl;

        public CustomLinkResolver(HtmlNodeConverterContext context, String fileUrl) {
            this.fileUrl = fileUrl;
        }

        public ResolvedLink resolveLink(Node node, HtmlNodeConverterContext context, ResolvedLink link) {
            String curr = link.getUrl();
            if (curr.startsWith("http")) {
                return link;
            }
            try {
                return link.withUrl((CharSequence)new URI(ContentFetcher.URL_PREFIX).resolve(this.fileUrl).resolve(curr).toString());
            }
            catch (Exception exception) {
                if (curr.startsWith("#")) {
                    return link.withUrl((CharSequence)(ContentFetcher.URL_PREFIX + this.fileUrl + curr));
                }
                if (curr.startsWith(".")) {
                    return link.withUrl((CharSequence)(ContentFetcher.URL_PREFIX + this.fileUrl + curr));
                }
                return link.withUrl((CharSequence)(ContentFetcher.URL_PREFIX + curr));
            }
        }

        static class Factory
        implements HtmlLinkResolverFactory {
            String fileUrl;

            @Nullable
            public Set<Class<?>> getAfterDependents() {
                return null;
            }

            @Nullable
            public Set<Class<?>> getBeforeDependents() {
                return null;
            }

            public boolean affectsGlobalScope() {
                return false;
            }

            public HtmlLinkResolver apply(HtmlNodeConverterContext context) {
                return new CustomLinkResolver(context, this.fileUrl);
            }

            public Factory(String fileUrl) {
                this.fileUrl = fileUrl;
            }
        }
    }
}

