/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals;

import ai.vespa.schemals.common.SchemaDiagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;

public class SchemaDiagnosticsHandler {
    private LanguageClient client;
    private Map<String, List<Diagnostic>> documentDiagnostics = new HashMap<String, List<Diagnostic>>();

    public void connectClient(LanguageClient client) {
        this.client = client;
    }

    public void clearDiagnostics(String fileURI) {
        this.publishDiagnostics(fileURI, new ArrayList<Diagnostic>());
        this.documentDiagnostics.remove(fileURI);
    }

    public void publishDiagnostics(String fileURI, List<Diagnostic> diagnostics) {
        this.insertDocumentIfNotExists(fileURI);
        this.client.publishDiagnostics(new PublishDiagnosticsParams(fileURI, diagnostics));
        this.documentDiagnostics.get(fileURI).clear();
        this.documentDiagnostics.get(fileURI).addAll(diagnostics);
    }

    public void replaceUndefinedSymbolDiagnostics(String fileURI, List<Diagnostic> unresolvedSymbolDiagnostics) {
        Predicate<Diagnostic> undefinedSymbolPredicate = diagnostic -> diagnostic.getCode().isRight() && ((Integer)diagnostic.getCode().getRight()).equals(SchemaDiagnostic.DiagnosticCode.UNDEFINED_SYMBOL.ordinal());
        this.insertDocumentIfNotExists(fileURI);
        this.documentDiagnostics.get(fileURI).removeIf(undefinedSymbolPredicate);
        this.documentDiagnostics.get(fileURI).addAll(unresolvedSymbolDiagnostics.stream().filter(undefinedSymbolPredicate).toList());
        this.publishDiagnostics(fileURI, List.copyOf((Collection)this.documentDiagnostics.get(fileURI)));
    }

    private void insertDocumentIfNotExists(String fileURI) {
        if (this.documentDiagnostics.containsKey(fileURI)) {
            return;
        }
        this.documentDiagnostics.put(fileURI, new ArrayList());
    }
}

