/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command.commandtypes;

import ai.vespa.schemals.context.EventExecuteCommandContext;
import ai.vespa.schemals.lsp.common.command.CommandUtils;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;

public class DocumentOpen
implements SchemaCommand {
    private String fileURI;

    @Override
    public Object execute(EventExecuteCommandContext context) {
        URI uriToOpen;
        if (this.fileURI == null) {
            return null;
        }
        try {
            uriToOpen = new URI(this.fileURI);
            if (uriToOpen.getScheme() == null) {
                throw new URISyntaxException(this.fileURI, "Expected a scheme.");
            }
        }
        catch (URISyntaxException ex) {
            if (context.scheduler.getWorkspaceURI() == null) {
                return null;
            }
            uriToOpen = URI.create(context.scheduler.getWorkspaceURI()).resolve(this.fileURI);
        }
        context.logger.info("Show document: " + uriToOpen.toString());
        context.messageHandler.showDocument(uriToOpen.toString()).join();
        return null;
    }

    @Override
    public boolean setArguments(List<Object> arguments2) {
        assert (arguments2.size() == this.getArity());
        Optional<String> argument2 = CommandUtils.getStringArgument(arguments2.get(0));
        if (argument2.isEmpty()) {
            return false;
        }
        this.fileURI = argument2.get();
        return true;
    }

    @Override
    public int getArity() {
        return 1;
    }
}

