/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression;

import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.FunctionSignature;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.GenericFunction;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.EnumArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.ExpressionArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.FieldArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.IntegerArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.KeywordArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.LabelArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.StringArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.SymbolArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.TensorTypeArgument;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.VectorArgument;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BuiltInFunctions {
    public static final Map<String, GenericFunction> rankExpressionBuiltInFunctions = new HashMap<String, GenericFunction>(){
        {
            this.put("query", new GenericFunction("query", new FunctionSignature(new SymbolArgument(Symbol.SymbolType.QUERY_INPUT, "value"))));
            this.put("term", new GenericFunction("term", new IntegerArgument(), Set.of("", "significance", "weight", "connectedness")));
            this.put("queryTermCount", new GenericFunction("queryTermCount"));
            this.put("fieldLength", new GenericFunction("fieldLength", new FunctionSignature(new FieldArgument())));
            this.put("attribute", new GenericFunction("attribute", List.of(new FunctionSignature((Argument)new FieldArgument(FieldArgument.NumericOrTensorFieldType, FieldArgument.IndexAttributeType), Set.of("", "count")), new FunctionSignature(List.of(new FieldArgument(FieldArgument.FieldType.NUMERIC_ARRAY, FieldArgument.IndexAttributeType), new IntegerArgument())), new FunctionSignature(List.of(new FieldArgument(FieldArgument.FieldType.WSET, FieldArgument.IndexAttributeType), new StringArgument("key")), Set.of("", "weight", "contains")))));
            this.put("tensorFromWeightedSet", new GenericFunction("tensorFromWeightedSet", List.of(new FunctionSignature(new FieldArgument(FieldArgument.FieldType.WSET, FieldArgument.IndexAttributeType, "source")), new FunctionSignature(List.of(new FieldArgument(FieldArgument.FieldType.WSET, FieldArgument.IndexAttributeType, "source"), new StringArgument("dimension"))))));
            this.put("tensorFromLabels", new GenericFunction("tensorFromLabels", List.of(new FunctionSignature(new FieldArgument(FieldArgument.SingleValueOrArrayType, FieldArgument.IndexAttributeType, "attribute")), new FunctionSignature(List.of(new FieldArgument(FieldArgument.SingleValueOrArrayType, FieldArgument.IndexAttributeType, "attribute"), new StringArgument("dimension"))))));
            this.put("fieldMatch", new GenericFunction("fieldMatch", new FieldArgument(FieldArgument.FieldType.STRING), Set.of("", "proximity", "completeness", "queryCompleteness", "fieldCompleteness", "orderness", "relatedness", "earliness", "longestSequenceRatio", "seqmentProximity", "unweightedProximity", "absoluteProximity", "occurrence", "absoluteOccurrence", "weightedOccurrence", "weightedAbsoluteOccurrence", "significantOccurrence", "weight", "significance", "importance", "segments", "matches", "degradedMatches", "outOfOrder", "gaps", "gapLength", "longestSequence", "head", "tail", "segmentDistance")));
            this.put("textSimilarity", new GenericFunction("textSimilarity", new FieldArgument(FieldArgument.FieldType.STRING), Set.of("", "proximity", "order", "queryCoverage", "fieldCoverage")));
            this.put("fieldTermMatch", new GenericFunction("fieldTermMatch", new FunctionSignature(List.of(new FieldArgument(FieldArgument.FieldType.STRING), new IntegerArgument()), Set.of("", "firstPosition", "lastPosition", "occurrences", "weight", "exactness"))));
            this.put("matchCount", new GenericFunction("mathCount", new FunctionSignature(new FieldArgument(FieldArgument.FieldType.STRING, FieldArgument.IndexAttributeType))));
            this.put("matches", new GenericFunction("matches", List.of(new FunctionSignature(new FieldArgument(FieldArgument.AnyFieldType, FieldArgument.IndexAttributeType)), new FunctionSignature(List.of(new FieldArgument(FieldArgument.AnyFieldType, FieldArgument.IndexAttributeType), new IntegerArgument())))));
            this.put("termDistance", new GenericFunction("termDistance", new FunctionSignature(List.of(new FieldArgument(), new ExpressionArgument("x"), new ExpressionArgument("y")), Set.of("", "forward", "forwardTermPosition", "reverse", "reverseTermPosition"))));
            this.put("elementCompleteness", new GenericFunction("elementCompleteness", new FunctionSignature((Argument)new FieldArgument(), Set.of("", "completeness", "fieldCompleteness", "queryCompleteness", "elementWeight"))));
            this.put("elementSimilarity", new GenericFunction("elementSimilarity", new FunctionSignature(new FieldArgument())));
            this.put("attributeMatch", new GenericFunction("attributeMatch", new FunctionSignature((Argument)new FieldArgument(), Set.of("", "completeness", "queryCompleteness", "fieldCompleteness", "normalizedWeight", "normalizedWeightedWeight", "weight", "significance", "importance", "matches", "totalWeight", "averageWeight", "maxWeight"))));
            this.put("closeness", new GenericFunction("closeness", List.of(new FunctionSignature(List.of(new KeywordArgument("field", "dimension"), new FieldArgument(FieldArgument.FieldType.TENSOR, FieldArgument.IndexAttributeType, "name"))), new FunctionSignature(List.of(new KeywordArgument("label", "dimension"), new LabelArgument("name"))), new FunctionSignature((Argument)new FieldArgument(FieldArgument.FieldType.POSITION, FieldArgument.IndexAttributeType, "name"), Set.of("", "logscale")))));
            this.put("freshness", new GenericFunction("freshness", new FunctionSignature((Argument)new FieldArgument(FieldArgument.AnyFieldType, FieldArgument.IndexAttributeType, "name"), Set.of("", "logscale"))));
            this.put("bm25", new GenericFunction("bm25", new FunctionSignature(new FieldArgument("field"))));
            this.put("elementwise", new GenericFunction("elementwise", List.of(new FunctionSignature(List.of(new ExpressionArgument("bm25(field)"), new StringArgument("dimension"))), new FunctionSignature(List.of(new ExpressionArgument("bm25(field)"), new StringArgument("dimension"), new TensorTypeArgument("cell_type"))))));
            this.put("nativeRank", new GenericFunction("nativeRank", List.of(new FunctionSignature(), new FunctionSignature((Argument)new FieldArgument("field"), true))));
            this.put("nativeDotProduct", new GenericFunction("nativeDotProduct"));
            this.put("firstPhase", new GenericFunction("firstPhase"));
            this.put("secondPhase", new GenericFunction("secondPhase"));
            this.put("firstPhaseRank", new GenericFunction("firstPhaseRank"));
            this.put("nativeFieldMatch", new GenericFunction("nativeFieldMatch", List.of(new FunctionSignature(), new FunctionSignature((Argument)new FieldArgument(), true))));
            this.put("nativeAttributeMatch", new GenericFunction("nativeAttributeMatch", List.of(new FunctionSignature(), new FunctionSignature((Argument)new FieldArgument(), true))));
            this.put("tokenInputIds", new GenericFunction("tokenInputIds", new FunctionSignature(List.of(new IntegerArgument("length"), new ExpressionArgument("input")), true)));
            this.put("customTokenInputIds", new GenericFunction("customTokenInputIds", new FunctionSignature(List.of(new IntegerArgument("start_sequence_id"), new IntegerArgument("sep_sequence_idlength"), new ExpressionArgument("input")), true)));
            this.put("tokenTypeIds", new GenericFunction("tokenTypeIds", new FunctionSignature(List.of(new IntegerArgument("length"), new ExpressionArgument("input")), true)));
            this.put("tokenAttentionMask", new GenericFunction("tokenAttentionMask", new FunctionSignature(List.of(new IntegerArgument("length"), new ExpressionArgument("input")), true)));
            this.put("globalSequence", new GenericFunction("globalSequence"));
            this.put("now", new GenericFunction("now"));
            this.put("random", new GenericFunction("random"));
            this.put("closest", new GenericFunction("closest", (List<FunctionSignature>)new ArrayList<FunctionSignature>(){
                {
                    this.add(new FunctionSignature(new FieldArgument()));
                    this.add(new FunctionSignature((List<Argument>)new ArrayList<Argument>(){
                        {
                            this.add(new FieldArgument());
                            this.add(new LabelArgument());
                        }
                    }));
                }
            }));
            this.put("distance", new GenericFunction("distance", List.of(new FunctionSignature(List.of(new KeywordArgument("field", "dimension"), new FieldArgument())), new FunctionSignature(List.of(new KeywordArgument("label", "dimension"), new LabelArgument("name"))), new FunctionSignature((Argument)new FieldArgument(FieldArgument.FieldType.POSITION, FieldArgument.IndexAttributeType, "name"), Set.of("", "km", "index", "latitude", "longitude")))));
            this.put("age", new GenericFunction("age", new FunctionSignature(new FieldArgument(FieldArgument.AnyFieldType, FieldArgument.IndexAttributeType))));
            this.put("file", new GenericFunction("file"));
            this.put("constant", new GenericFunction("constant", new FunctionSignature(new SymbolArgument(Symbol.SymbolType.RANK_CONSTANT, "name"))));
            this.put("distanceToPath", new GenericFunction("distanceToPath", new FunctionSignature((Argument)new FieldArgument(FieldArgument.FieldType.POSITION, FieldArgument.IndexAttributeType), Set.of("", "distance", "traveled", "product"))));
            this.put("dotProduct", new GenericFunction("dotProduct", new FunctionSignature(List.of(new FieldArgument(EnumSet.of(FieldArgument.FieldType.STRING, FieldArgument.FieldType.INTEGER, FieldArgument.FieldType.NUMERIC_ARRAY)), new VectorArgument()))));
            this.put("rawScore", new GenericFunction("rawScore", new FunctionSignature(new FieldArgument())));
            this.put("itemRawScore", new GenericFunction("itemRawScore", new FunctionSignature(new LabelArgument())));
            this.put("foreach", new GenericFunction("foreach", List.of(new FunctionSignature(List.of(new KeywordArgument("fields", "dimension"), new StringArgument("variable"), new ExpressionArgument("feature"), new StringArgument("condition"), new EnumArgument("operation", List.of("sum", "product", "average", "min", "max", "count")))), new FunctionSignature(List.of(new KeywordArgument("terms", "dimension"), new StringArgument("variable"), new ExpressionArgument("feature"), new StringArgument("condition"), new EnumArgument("operation", List.of("sum", "product", "average", "min", "max", "count")))), new FunctionSignature(List.of(new KeywordArgument("attributes", "dimension"), new StringArgument("variable"), new ExpressionArgument("feature"), new StringArgument("condition"), new EnumArgument("operation", List.of("sum", "product", "average", "min", "max", "count")))))));
            this.put("onnx", new GenericFunction("onnx", new FunctionSignature(new SymbolArgument(Symbol.SymbolType.ONNX_MODEL, "onnx-model")).withAnyProperty()));
            this.put("onnxModel", new GenericFunction("onnxModel", new FunctionSignature(new SymbolArgument(Symbol.SymbolType.ONNX_MODEL, "onnx-model")).withAnyProperty()));
            this.put("lightgbm", new GenericFunction("lightgbm", new FunctionSignature(new StringArgument("\"lightgbm-model-name\""))));
            this.put("xgboost", new GenericFunction("xgboost", new FunctionSignature(new StringArgument("\"xgboost-model-name\""))));
            this.put("subqueries", new GenericFunction("subqueries", new FunctionSignature((Argument)new FieldArgument(FieldArgument.FieldType.PREDICATE), Set.of("", "lsb", "msb"))));
        }
    };
    public static final Set<String> simpleBuiltInFunctionsSet = new HashSet<String>(){
        {
            this.add("match");
            this.add("nativeProximity");
            this.add("randomNormal");
            this.add("randomNormalStable");
            this.add("rankingExpression");
            this.add("normalize_linear");
            this.add("reciprocal_rank");
            this.add("reciprocal_rank");
            this.add("reciprocal_rank_fusion");
        }
    };
}

