/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.formatting;

import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.ast.openLbrace;
import ai.vespa.schemals.tree.Node;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.FormattingOptions;

class FormattingUtils {
    FormattingUtils() {
    }

    static int computeNodeIndentLevel(Node containing, FormattingOptions options) {
        int startCharacter = containing.getRange().getStart().getCharacter();
        if (options.isInsertSpaces()) {
            return startCharacter / options.getTabSize();
        }
        return startCharacter;
    }

    static void findNodesInLineRange(Node node, LineRange range, List<Node> result) {
        int nodeFirstLine = node.getRange().getStart().getLine();
        if (nodeFirstLine > range.lastLine()) {
            return;
        }
        if (nodeFirstLine >= range.firstLine()) {
            result.add(node);
            return;
        }
        for (Node child : node) {
            FormattingUtils.findNodesInLineRange(child, range, result);
        }
    }

    static Node getFirstLbraceAncestor(Node node) {
        for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (FormattingUtils.getNodeLbraceIndex(parent) == -1) continue;
            return parent;
        }
        return null;
    }

    static int getNodeLbraceIndex(Node node) {
        for (int i = 0; i < node.size(); ++i) {
            if (!node.get(i).isASTInstance(openLbrace.class)) continue;
            return i;
        }
        return -1;
    }

    static String createIndentationString(int indentLevel, FormattingOptions options) {
        if (indentLevel == 0) {
            return "";
        }
        if (options.isInsertSpaces()) {
            return new String(new char[indentLevel * options.getTabSize()]).replace("\u0000", " ");
        }
        return new String(new char[indentLevel]).replace("\u0000", "\t");
    }

    static boolean shouldHaveSpaceBetween(Node left, Node right) {
        String leftText = left.findLastLeaf().getText();
        String rightText = right.getText();
        if (leftText.isEmpty() || rightText.isEmpty()) {
            return false;
        }
        int leftLast = leftText.codePointAt(leftText.length() - 1);
        int rightFirst = rightText.codePointAt(0);
        if (Character.isLetterOrDigit(rightFirst) && Character.isLetterOrDigit(leftLast)) {
            return true;
        }
        if (rightFirst == 46 || rightFirst == 58) {
            return false;
        }
        return leftLast == 58 || leftLast == 44 || leftLast == 41;
    }

    static boolean isEOF(Node node) {
        if (node == null) {
            return false;
        }
        if (node.getSchemaNode() == null) {
            return false;
        }
        if (node.getSchemaNode().getOriginalSchemaNode() == null) {
            return false;
        }
        return node.getSchemaNode().getOriginalSchemaNode().getType() == Token.TokenType.EOF;
    }

    record LineRange(int firstLine, int lastLine) {
    }

    record FormatPositionInformation(int indentLevel, boolean nodeStartsLine, Optional<LineRange> formatRange) {
    }
}

