/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.parser.ast.consumedExpressionElm;
import ai.vespa.schemals.parser.ast.consumedFeatureListElm;
import ai.vespa.schemals.parser.rankingexpression.ParseException;
import ai.vespa.schemals.parser.rankingexpression.RankingExpressionParser;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;

public class SchemaRankingExpressionParser {
    private static SchemaNode parseRankingExpression(ParseContext context, SchemaNode node, List<Diagnostic> diagnostics) {
        String expressionString = node.getRankingExpressionString();
        RankingExpressionParser tolerantParser = new RankingExpressionParser(context.fileURI(), expressionString);
        tolerantParser.setParserTolerant(true);
        try {
            if (node.isASTInstance(consumedExpressionElm.class)) {
                tolerantParser.expression();
            } else if (node.isASTInstance(consumedFeatureListElm.class)) {
                tolerantParser.featureList();
            } else {
                tolerantParser.rankPropertyFeature();
            }
        }
        catch (ParseException parseException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (tolerantParser.rootNode() == null) {
            return null;
        }
        return new SchemaNode(tolerantParser.rootNode(), node.getRange().getStart());
    }

    static void embedCST(ParseContext context, SchemaNode node, List<Diagnostic> diagnostics) {
        if (CSTUtils.rangeIsEmpty(node.getRange())) {
            return;
        }
        node.addChild(SchemaRankingExpressionParser.parseRankingExpression(context, node, diagnostics));
    }
}

