/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.fieldElm;
import ai.vespa.schemals.schemadocument.resolvers.IndexingLanguageResolver;
import ai.vespa.schemals.schemadocument.resolvers.RankExpressionSymbolResolver;
import ai.vespa.schemals.schemadocument.resolvers.SymbolReferenceResolver;
import ai.vespa.schemals.schemadocument.resolvers.ValidateFieldSettings;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;

public class ResolverTraversal {
    public static List<Diagnostic> traverse(ParseContext context, SchemaNode CST) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        ResolverTraversal.traverse(context, CST, diagnostics, false);
        return diagnostics;
    }

    private static void traverse(ParseContext context, SchemaNode currentNode, List<Diagnostic> diagnostics, boolean insideRankExpression) {
        if (currentNode.getLanguageType() == Node.LanguageType.RANK_EXPRESSION && !insideRankExpression) {
            diagnostics.addAll(RankExpressionSymbolResolver.resolveRankExpression(currentNode, context));
        }
        if (currentNode.hasSymbol() && currentNode.getSymbol().getStatus() == Symbol.SymbolStatus.UNRESOLVED) {
            SymbolReferenceResolver.resolveSymbolReference(currentNode, context, diagnostics);
        }
        if (currentNode.containsOtherLanguageData(Node.LanguageType.INDEXING)) {
            IndexingLanguageResolver.resolveIndexingLanguage(context, currentNode, diagnostics);
        }
        for (Node child : currentNode) {
            ResolverTraversal.traverse(context, child.getSchemaNode(), diagnostics, insideRankExpression || currentNode.getLanguageType() == Node.LanguageType.RANK_EXPRESSION);
        }
        if (currentNode.isASTInstance(fieldElm.class)) {
            ValidateFieldSettings.validateFieldSettings(context, currentNode, diagnostics);
        }
    }
}

