/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals;

import java.util.UUID;
import org.eclipse.lsp4j.ProgressParams;
import org.eclipse.lsp4j.WorkDoneProgressBegin;
import org.eclipse.lsp4j.WorkDoneProgressCreateParams;
import org.eclipse.lsp4j.WorkDoneProgressEnd;
import org.eclipse.lsp4j.WorkDoneProgressNotification;
import org.eclipse.lsp4j.WorkDoneProgressReport;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;

public class SchemaProgressHandler {
    private LanguageClient client;

    public void connectClient(LanguageClient client) {
        this.client = client;
    }

    public boolean connected() {
        return this.client != null;
    }

    public Progress newWorkDoneProgress(String title) {
        return new Progress(this.client, title, true);
    }

    public static class Progress {
        private final Either<String, Integer> token;
        private final LanguageClient client;
        private final boolean sendPercentage;

        protected Progress(LanguageClient client, Either<String, Integer> token) {
            this.client = client;
            this.token = token;
            this.sendPercentage = false;
        }

        Progress(LanguageClient client, String title, boolean sendPercentage) {
            this.token = Either.forLeft((Object)UUID.randomUUID().toString());
            this.client = client;
            this.sendPercentage = sendPercentage;
            client.createProgress(new WorkDoneProgressCreateParams(this.token));
            WorkDoneProgressBegin beginReport = new WorkDoneProgressBegin();
            beginReport.setTitle(title);
            if (sendPercentage) {
                beginReport.setPercentage(Integer.valueOf(0));
            }
            this.sendNotification((WorkDoneProgressNotification)beginReport);
        }

        private void sendNotification(WorkDoneProgressNotification notification) {
            this.client.notifyProgress(new ProgressParams(this.token, Either.forRight((Object)notification)));
        }

        public void partialResult(String message, Integer percentage) {
            WorkDoneProgressReport report = new WorkDoneProgressReport();
            report.setMessage(message);
            report.setPercentage(percentage);
            this.sendNotification((WorkDoneProgressNotification)report);
        }

        public void partialResult(String message) {
            if (this.sendPercentage) {
                throw new IllegalArgumentException("For Progresses with percentage, a percentage must be given");
            }
            this.partialResult(message, null);
        }

        public void end(String message) {
            WorkDoneProgressEnd report = new WorkDoneProgressEnd();
            if (message != null) {
                report.setMessage(message);
            }
            this.sendNotification((WorkDoneProgressNotification)report);
        }

        public void end() {
            this.end(null);
        }
    }
}

