/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.common;

import ai.vespa.schemals.SchemaMessageHandler;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.lsp4j.MessageType;

public class ClientLogger {
    protected SchemaMessageHandler messageHandler;

    public ClientLogger(SchemaMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void info(Object message) {
        if (!this.messageHandler.connected()) {
            return;
        }
        this.messageHandler.logMessage(MessageType.Info, message.toString());
    }

    public static String errorToString(Exception ex) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream logger = new PrintStream(outputStream);
        ex.printStackTrace(logger);
        return outputStream.toString();
    }

    public void error(Exception ex) {
        this.error(ClientLogger.errorToString(ex));
    }

    public void error(Object message) {
        if (!this.messageHandler.connected()) {
            return;
        }
        this.messageHandler.logMessage(MessageType.Error, message.toString());
    }

    public void warning(Object message) {
        if (!this.messageHandler.connected()) {
            return;
        }
        this.messageHandler.logMessage(MessageType.Warning, message.toString());
    }
}

