/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.semantictokens;

import ai.vespa.schemals.lsp.schema.semantictokens.SchemaSemanticTokens;
import ai.vespa.schemals.lsp.yqlplus.semantictokens.YQLPlusSemanticTokens;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.SemanticTokensLegend;
import org.eclipse.lsp4j.SemanticTokensServerFull;
import org.eclipse.lsp4j.SemanticTokensWithRegistrationOptions;

public class CommonSemanticTokens {
    private static List<String> tokenTypes = new ArrayList<String>();
    private static List<String> tokenModifiers = new ArrayList<String>();

    public static SemanticTokensWithRegistrationOptions getSemanticTokensRegistrationOptions() {
        SchemaSemanticTokens.init();
        YQLPlusSemanticTokens.init();
        return new SemanticTokensWithRegistrationOptions(new SemanticTokensLegend(tokenTypes, tokenModifiers), new SemanticTokensServerFull(Boolean.valueOf(false)));
    }

    private static int addUniqueToList(List<String> list, String element) {
        int index = list.indexOf(element);
        if (index == -1) {
            index = list.size();
            list.add(element);
        }
        return index;
    }

    public static int addTokenType(String name) {
        return CommonSemanticTokens.addUniqueToList(tokenTypes, name);
    }

    public static void addTokenTypes(List<String> names) {
        for (String name : names) {
            CommonSemanticTokens.addTokenType(name);
        }
    }

    public static Integer getType(String token) {
        return tokenTypes.indexOf(token);
    }

    public static int addTokenModifier(String modifier) {
        return CommonSemanticTokens.addUniqueToList(tokenModifiers, modifier);
    }

    public static void addTokenModifiers(List<String> modifiers) {
        for (String modifier : modifiers) {
            CommonSemanticTokens.addTokenModifier(modifier);
        }
    }

    public static Integer getModifier(String modifier) {
        return tokenModifiers.indexOf(modifier);
    }
}

